package com.finconsgroup.itserr.marketplace.institutional_page.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import static com.finconsgroup.itserr.marketplace.institutional_page.bs.util.Constants.MAX_MEDIUM_TEXT_LENGTH;
import static com.finconsgroup.itserr.marketplace.institutional_page.bs.util.Constants.MAX_URL_LENGTH;
import static com.finconsgroup.itserr.marketplace.institutional_page.bs.util.Constants.VALIDATION_ERROR_FIELD_LENGTH;
import static com.finconsgroup.itserr.marketplace.institutional_page.bs.util.Constants.VALIDATION_ERROR_REQUIRED_FIELD;

/**
 * Input Dto of a button related to the institutional page.
 */
@Schema(name = "InputButtonDto", description = "Input DTO of a button related to the institutional page")
@Data
@Builder
@AllArgsConstructor
public class InputButtonDto {

    @Schema(description = "The label of the button", example = "Download Criterion")
    @NotBlank(message = VALIDATION_ERROR_REQUIRED_FIELD)
    @Size(max = MAX_MEDIUM_TEXT_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String label;

    @Schema(description = "The action link of the button", example = "https://www.google.com/")
    @NotBlank(message = VALIDATION_ERROR_REQUIRED_FIELD)
    @Size(max = MAX_URL_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String link;

    @Schema(description = "The type of the button, used to determine its behavior", example = "Download")
    @NotBlank(message = VALIDATION_ERROR_REQUIRED_FIELD)
    @Size(max = MAX_MEDIUM_TEXT_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String buttonType;

    @Schema(description = "CSS class name for the icon displayed inside the button", example = "fa-download")
    @Size(max = MAX_MEDIUM_TEXT_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String iconCssClass;

}
