/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutional_page.bs.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2AuthenticationException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.InstitutionalPageDmClient;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.InstitutionalPageIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.ModerationIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.component.InstitutionalPageEntityProducer;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputModerationStatusDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputSearchModerationInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.mapper.InstitutionalPageMapper;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.mapper.ModerationMapper;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.NotificationMessageFactory;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.NotificationProducer;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.service.ModerationService;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.service.impl.DefaultModerationService;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import feign.FeignException;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DefaultModerationService
implements ModerationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultModerationService.class);
    private final ModerationMapper moderationMapper;
    private final InstitutionalPageMapper institutionalPageMapper;
    private final InstitutionalPageDmClient institutionalPageDmClient;
    private final InstitutionalPageEntityProducer institutionalPageEntityProducer;
    private final NotificationMessageFactory notificationMessageFactory;
    private final NotificationProducer notificationProducer;

    public OutputPageDto<OutputInstitutionalPageDto> getModerationInstitutionalPages(Set<String> associationsToLoad, int pageNumber, int pageSize, String sort, SortDirection direction) {
        try {
            OutputPageDto pendingInstitutionalPages = this.institutionalPageDmClient.getModerationInstitutionalPages(associationsToLoad, pageNumber, pageSize, sort, direction);
            return this.institutionalPageMapper.toOutputPageDto(pendingInstitutionalPages);
        }
        catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException(e.getMessage());
        }
        catch (FeignException e) {
            throw new WP2BusinessException((Throwable)e);
        }
    }

    public OutputInstitutionalPageDto getModerationInstitutionalPageById(UUID institutionalPageId) {
        try {
            InstitutionalPageIPDmDto pendingInstitutionalPage = this.institutionalPageDmClient.getModerationInstitutionalPageById(institutionalPageId);
            return this.institutionalPageMapper.toOutputInstitutionalPageDto(pendingInstitutionalPage, true);
        }
        catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException(e.getMessage());
        }
        catch (FeignException.NotFound e) {
            throw new WP2ResourceNotFoundException((Throwable)e);
        }
        catch (FeignException e) {
            throw new WP2BusinessException((Throwable)e);
        }
    }

    public OutputInstitutionalPageDto changeInstitutionalPageModerationStatus(UUID institutionalPageId, InputModerationStatusDto inputModerationStatusDto) {
        try {
            ModerationIPDmDto moderationIPDmDto = this.institutionalPageDmClient.changeInstitutionalPageModerationStatus(institutionalPageId, this.moderationMapper.toModerationStatusDmDto(inputModerationStatusDto));
            OutputInstitutionalPageDto institutionalPageDto = this.institutionalPageMapper.toOutputInstitutionalPageDto(moderationIPDmDto.getInstitutionalPage(), true);
            MessagingEventDto statusChangeNotification = this.notificationMessageFactory.createInstitutionalPageStatusChangeNotification(inputModerationStatusDto, moderationIPDmDto);
            this.notificationProducer.publishInstitutionalPageStatusChangeNotification(statusChangeNotification);
            if (inputModerationStatusDto.getApproved().booleanValue()) {
                switch (1.$SwitchMap$com$finconsgroup$itserr$marketplace$institutional_page$bs$enums$OperationType[moderationIPDmDto.getOperationType().ordinal()]) {
                    case 1: {
                        this.institutionalPageEntityProducer.publishCreateEvent(institutionalPageDto);
                        break;
                    }
                    case 2: {
                        this.institutionalPageEntityProducer.publishUpdateEvent(institutionalPageDto);
                        break;
                    }
                    case 3: {
                        this.institutionalPageEntityProducer.publishDeleteEvent(institutionalPageDto);
                        break;
                    }
                    default: {
                        log.error("Operation type not supported: {}", (Object)moderationIPDmDto.getOperationType());
                        throw new WP2BusinessException("Operation type not supported: " + String.valueOf(moderationIPDmDto.getOperationType()));
                    }
                }
            }
            return institutionalPageDto;
        }
        catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException(e.getMessage());
        }
        catch (FeignException.NotFound e) {
            throw new WP2ResourceNotFoundException((Throwable)e);
        }
        catch (FeignException e) {
            throw new WP2BusinessException((Throwable)e);
        }
    }

    public OutputPageDto<OutputInstitutionalPageDto> searchModerationInstitutionalPages(InputSearchModerationInstitutionalPageDto inputSearchModerationInstitutionalPageDto, Set<String> associationsToLoad, int pageNumber, int pageSize, String sort, SortDirection direction) {
        try {
            OutputPageDto clientResponse = this.institutionalPageDmClient.searchModerationInstitutionalPages(inputSearchModerationInstitutionalPageDto, associationsToLoad, pageNumber, pageSize, sort, direction);
            return clientResponse.map(institutionalPageIPDmDto -> this.institutionalPageMapper.toOutputInstitutionalPageDto(institutionalPageIPDmDto, true));
        }
        catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException(e.getMessage());
        }
        catch (FeignException e) {
            throw new WP2BusinessException((Throwable)e);
        }
    }

    @Generated
    public DefaultModerationService(ModerationMapper moderationMapper, InstitutionalPageMapper institutionalPageMapper, InstitutionalPageDmClient institutionalPageDmClient, InstitutionalPageEntityProducer institutionalPageEntityProducer, NotificationMessageFactory notificationMessageFactory, NotificationProducer notificationProducer) {
        this.moderationMapper = moderationMapper;
        this.institutionalPageMapper = institutionalPageMapper;
        this.institutionalPageDmClient = institutionalPageDmClient;
        this.institutionalPageEntityProducer = institutionalPageEntityProducer;
        this.notificationMessageFactory = notificationMessageFactory;
        this.notificationProducer = notificationProducer;
    }
}

