/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutional_page.bs.component;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2FeignClientException;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.InstitutionalPageDmClient;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.InstitutionalPageIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.InstitutionalPageViewIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.mapper.InstitutionalPageMapper;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.InstitutionalPageProducer;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class InstitutionalPageEntityProducer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstitutionalPageEntityProducer.class);
    private final InstitutionalPageMapper institutionalPageMapper;
    private final InstitutionalPageDmClient institutionalPageDmClient;
    private final InstitutionalPageProducer institutionalPageProducer;

    public void publishCreateEvent(OutputInstitutionalPageDto outputInstitutionalPageDto) {
        this.institutionalPageProducer.publishCreateEvent(outputInstitutionalPageDto);
    }

    public void publishUpdateEvent(OutputInstitutionalPageDto outputInstitutionalPageDto) {
        if (InstitutionalPageEntityProducer.isApprovedInstitutionalPage((OutputInstitutionalPageDto)outputInstitutionalPageDto)) {
            this.institutionalPageProducer.publishUpdateEvent(outputInstitutionalPageDto);
        }
    }

    public void publishDeleteEvent(OutputInstitutionalPageDto outputInstitutionalPageDto) {
        if (InstitutionalPageEntityProducer.isApprovedInstitutionalPage((OutputInstitutionalPageDto)outputInstitutionalPageDto)) {
            this.institutionalPageProducer.publishDeleteEvent(outputInstitutionalPageDto);
        }
    }

    public void publishUpdateEventIfApprovedInstitutionalPageExists(UUID institutionalPageId) {
        InstitutionalPageIPDmDto approvedInstitutionalPageDmDto;
        try {
            approvedInstitutionalPageDmDto = this.retrieveApprovedInstitutionalPageById(institutionalPageId);
        }
        catch (WP2FeignClientException exception) {
            if (exception.getHttpStatus() == HttpStatus.NOT_FOUND) {
                return;
            }
            throw exception;
        }
        OutputInstitutionalPageDto approvedInstitutionalPageDto = this.institutionalPageMapper.toOutputInstitutionalPageDto(approvedInstitutionalPageDmDto, true);
        this.publishUpdateEvent(approvedInstitutionalPageDto);
    }

    public void publishDeleteApprovedInstitutionalPageEntityIfExists(UUID institutionalPageId) {
        InstitutionalPageIPDmDto approvedInstitutionalPageDmDto;
        try {
            approvedInstitutionalPageDmDto = this.retrieveApprovedInstitutionalPageById(institutionalPageId);
        }
        catch (WP2FeignClientException exception) {
            if (exception.getHttpStatus() == HttpStatus.NOT_FOUND) {
                return;
            }
            throw exception;
        }
        OutputInstitutionalPageDto approvedInstitutionalPageDto = this.institutionalPageMapper.toOutputInstitutionalPageDto(approvedInstitutionalPageDmDto, true);
        this.institutionalPageProducer.publishDeleteEvent(approvedInstitutionalPageDto);
    }

    public static boolean isApprovedInstitutionalPage(OutputInstitutionalPageDto outputInstitutionalPageDto) {
        return outputInstitutionalPageDto.getModerationStatus().equals(InstitutionalPageViewIPDmDto.APPROVED.getLabel());
    }

    private InstitutionalPageIPDmDto retrieveApprovedInstitutionalPageById(UUID institutionalPageId) {
        return this.institutionalPageDmClient.getInstitutionalPageById(institutionalPageId, InstitutionalPageViewIPDmDto.APPROVED, Boolean.valueOf(false));
    }

    @Generated
    public InstitutionalPageEntityProducer(InstitutionalPageMapper institutionalPageMapper, InstitutionalPageDmClient institutionalPageDmClient, InstitutionalPageProducer institutionalPageProducer) {
        this.institutionalPageMapper = institutionalPageMapper;
        this.institutionalPageDmClient = institutionalPageDmClient;
        this.institutionalPageProducer = institutionalPageProducer;
    }
}

