package com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.impl;

import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.InstitutionalPageProducer;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

/**
 * Local stub implementation of {@link InstitutionalPageProducer}.
 * <p>
 * This implementation does not send any real messages but logs the invocation for testing purposes.
 */
@Component
@ConditionalOnProperty(name = "messaging.enabled", havingValue = "false")
@Slf4j
public class LoggerInstitutionalPageProducer implements InstitutionalPageProducer {
    @Override
    public void publishCreateEvent(OutputInstitutionalPageDto institutionalPage) {
        log.info("Message dispatch skipped (local profile) - CREATED institutional page: {}", institutionalPage.getId());
    }

    @Override
    public void publishUpdateEvent(OutputInstitutionalPageDto institutionalPage) {
        log.info("Message dispatch skipped (local profile) - UPDATED institutional page: {}", institutionalPage.getId());
    }

    @Override
    public void publishDeleteEvent(OutputInstitutionalPageDto institutionalPage) {
        log.info("Message dispatch skipped (local profile) - DELETED institutional page: {}", institutionalPage.getId());
    }
}
