/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2AuthenticationException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.FileUploadWorkspaceBsClient;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.dto.DocumentWorkspaceBsDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.config.properties.WorkspaceBsConfigurationProperties;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class DefaultFileUploadWorkspaceBsClient
implements FileUploadWorkspaceBsClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultFileUploadWorkspaceBsClient.class);
    private final WorkspaceBsConfigurationProperties workspaceBsConfig;

    public DocumentWorkspaceBsDto createFile(InputStream file, UUID documentId, String fileName) {
        HttpClient client = HttpClient.newHttpClient();
        try {
            URI uri = URI.create(StringUtils.appendIfMissing((String)this.workspaceBsConfig.getBaseUrl().toString(), (CharSequence)"/", (CharSequence[])new CharSequence[0])).resolve("workspace/documents/").resolve(String.valueOf(documentId) + "/").resolve("content?fileName=" + fileName);
            HttpRequest.BodyPublisher p = HttpRequest.BodyPublishers.ofInputStream(() -> file);
            HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Authorization", "Bearer " + JwtTokenHolder.getTokenOrThrow()).PUT(p).build();
            HttpResponse response = DefaultFileUploadWorkspaceBsClient.executeRequest((HttpClient)client, (HttpRequest)request);
            switch (response.statusCode()) {
                case 200: 
                case 201: {
                    break;
                }
                case 401: {
                    throw new WP2AuthenticationException("Unauthenticated");
                }
                case 404: 
                case 406: {
                    throw new WP2ResourceNotFoundException("Document not found");
                }
                default: {
                    log.error("Error uploading file. workspace-bs status={}, workspace-bs body={}", (Object)response.statusCode(), response.body());
                    throw new WP2BusinessException("Error uploading file. status=" + response.statusCode());
                }
            }
            ObjectMapper mapper = new ObjectMapper();
            DocumentWorkspaceBsDto documentWorkspaceBsDto = (DocumentWorkspaceBsDto)mapper.readValue((String)response.body(), DocumentWorkspaceBsDto.class);
            if (client != null) {
                client.close();
            }
            return documentWorkspaceBsDto;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new WP2BusinessException("I/O error while uploading document", (Throwable)e);
            }
        }
    }

    private static HttpResponse<String> executeRequest(HttpClient client, HttpRequest request) throws IOException {
        try {
            return client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new WP2BusinessException("Interrupted", (Throwable)e);
        }
    }

    @Generated
    public DefaultFileUploadWorkspaceBsClient(WorkspaceBsConfigurationProperties workspaceBsConfig) {
        this.workspaceBsConfig = workspaceBsConfig;
    }
}

