package com.finconsgroup.itserr.marketplace.institutional_page.bs.service;

import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputParagraphDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageDto;

import java.util.UUID;

/**
 * Service for management of paragraphs
 */
public interface ParagraphService {

    /**
     * Create a paragraph for an institutional page
     *
     * @param institutionalPageId the id of the institutional page
     * @param paragraphDto the paragraph to create
     * @param position the position where to place the institutional page, if null at the end
     * @return the institutional page with the created paragraph
     */
    OutputInstitutionalPageDto createParagraph(UUID institutionalPageId, InputParagraphDto paragraphDto, Integer position);

    /**
     * Update a paragraph for an institutional page
     *
     * @param institutionalPageId the id of the institutional page
     * @param paragraphId the id of the paragraph to update
     * @param paragraphDto the paragraph updated
     * @return the institutional page with the updated paragraph
     */
    OutputInstitutionalPageDto updateParagraph(UUID institutionalPageId, UUID paragraphId, InputParagraphDto paragraphDto);

    /**
     * Delete a paragraph from an institutional page
     *
     * @param institutionalPageId the id of the institutional page
     * @param paragraphId the id of the paragraph
     * @return the institutional page with the deleted paragraph
     */
    OutputInstitutionalPageDto deleteParagraph(UUID institutionalPageId, UUID paragraphId);
}
