package com.finconsgroup.itserr.marketplace.institutional_page.bs.repository;

import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.UserProfileBsClient;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.dto.UserProfileBsDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.UserProfileDmClient;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.UserProfileDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.UserProfileIdsUserProfileDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.UserProfilesUserProfileDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.exceptions.WP2UserProfileNotFoundException;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.mapper.UserProfileMapper;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

import static com.finconsgroup.itserr.marketplace.core.web.security.jwt.SecurityRoles.CATALOGUE_EDIT_ROLE;


@Component
@RequiredArgsConstructor
public class UserProfileRepository {
    private final UserProfileDmClient userProfileDmClient;
    private final UserProfileBsClient userProfileBsClient;
    private final UserProfileMapper userProfileMapper;

    public List<OutputUserProfileDto> getMemberProfilesOrThrow(List<UUID> memberIdsList) {
        if (memberIdsList == null || memberIdsList.isEmpty()) {
            return List.of();
        }

        Set<UUID> memberIds = new HashSet<>(memberIdsList);

        // Retrieve the user profiles of the members
        UserProfilesUserProfileDmDto foundProfilesDto = userProfileDmClient.getProfilesByIds(
                new UserProfileIdsUserProfileDmDto(memberIds.stream().toList()),
                0,
                memberIds.size());

        // Check the missing/non-existing profiles and throw an exception if someone is missing
        if (foundProfilesDto.getContent().size() != memberIds.size()) {
            Set<UUID> foundProfileIds = foundProfilesDto.getContent().stream()
                    .map(UserProfileDmDto::getId)
                    .collect(Collectors.toSet());
            List<UUID> notFoundProfileIds = new ArrayList<>();
            memberIds.forEach(profileId -> {
                if (!foundProfileIds.contains(profileId)) {
                    notFoundProfileIds.add(profileId);
                }
            });
            throw new WP2UserProfileNotFoundException(notFoundProfileIds);
        }

        //Return the user profiles of the member if everyone is present
        List<OutputUserProfileDto> userProfiles = new ArrayList<>();
        foundProfilesDto.getContent().forEach(profile -> userProfiles.add(userProfileMapper.toOutputUserProfileDto(profile)));

        return userProfiles;
    }

    public UUID getAdmin() {
        return userProfileBsClient
                .getUserProfilesByRole(CATALOGUE_EDIT_ROLE)
                .stream()
                .findFirst()
                .map(UserProfileBsDto::getId)
                .orElse(null);
    }
}
