package com.finconsgroup.itserr.marketplace.institutional_page.bs.exceptions;

import com.finconsgroup.itserr.marketplace.core.web.exception.ErrorResponseDto;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;

import static com.finconsgroup.itserr.marketplace.core.web.exception.ExceptionUtils.createResponseEntityError;
import static com.finconsgroup.itserr.marketplace.core.web.exception.ExceptionUtils.logError;

/**
 * Global exception handler.
 */
@RestControllerAdvice
public class WP2InstitutionalPageBsExceptionHandler {
    /**
     * <p>Handles a {@link WP2UserProfileNotFoundException}, which means that some user profiles are not existing.</p>
     * <p>A 404 Not found is returned.</p>
     * @param ex Thrown exception.
     * @param request HTTP request.
     * @return Error response.
     */
    @ExceptionHandler(WP2UserProfileNotFoundException.class)
    @ResponseBody
    public ResponseEntity<ErrorResponseDto> handleUserProfileNotFoundException(
            final WP2UserProfileNotFoundException ex,
            final WebRequest request) {
        logError(ex, request);
        return createResponseEntityError(HttpStatus.NOT_FOUND, ex.getMessage());
    }

    /**
     * <p>Handles a {@link WP2InvalidImageException}, which means that image validation failed.</p>
     * <p>A 400 Bad Request is returned.</p>
     * @param ex Thrown exception.
     * @param request HTTP request.
     * @return Error response.
     */
    @ExceptionHandler(WP2InvalidImageException.class)
    @ResponseBody
    public ResponseEntity<ErrorResponseDto> handleInvalidImageException(
            final WP2InvalidImageException ex,
            final WebRequest request) {
        logError(ex, request);
        return createResponseEntityError(HttpStatus.BAD_REQUEST, ex.getMessage());
    }
}
