package com.finconsgroup.itserr.marketplace.institutional_page.bs.controller;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.api.ModerationApi;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputModerationStatusDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputSearchModerationInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.service.ModerationService;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

import java.util.Set;
import java.util.UUID;

@RestController
@RequiredArgsConstructor
public class ModerationController implements ModerationApi {
    private final ModerationService moderationService;

    @Override
    public ResponseEntity<OutputPageDto<OutputInstitutionalPageDto>> searchModerationInstitutionalPages(
            InputSearchModerationInstitutionalPageDto inputSearchModerationInstitutionalPageDto,
            Set<String> associationsToLoad,
            int pageNumber,
            int pageSize,
            String sort,
            SortDirection direction
    ) {
        OutputPageDto<OutputInstitutionalPageDto> moderationInstitutionalPages = moderationService.searchModerationInstitutionalPages(
                inputSearchModerationInstitutionalPageDto,
                associationsToLoad,
                pageNumber,
                pageSize,
                sort,
                direction
        );

        return new ResponseEntity<>(moderationInstitutionalPages, HttpStatus.OK);
    }

    @Override
    public ResponseEntity<OutputPageDto<OutputInstitutionalPageDto>> getModerationInstitutionalPages(
            Set<String> associationsToLoad,
            int pageNumber,
            int pageSize,
            String sort,
            SortDirection direction
    ) {
        OutputPageDto<OutputInstitutionalPageDto> moderationInstitutionalPages = moderationService.getModerationInstitutionalPages(
                associationsToLoad,
                pageNumber,
                pageSize,
                sort,
                direction
        );
        return new ResponseEntity<>(moderationInstitutionalPages, HttpStatus.OK);
    }

    @Override
    public ResponseEntity<OutputInstitutionalPageDto> getModerationInstitutionalPageById(UUID institutionalPageId) {
        OutputInstitutionalPageDto moderationInstitutionalPage = moderationService.getModerationInstitutionalPageById(institutionalPageId);
        return new ResponseEntity<>(moderationInstitutionalPage, HttpStatus.OK);
    }

    @Override
    public ResponseEntity<OutputInstitutionalPageDto> changeInstitutionalPageModerationStatus(
            UUID institutionalPageId,
            InputModerationStatusDto inputModerationStatusDto
    ) {
        OutputInstitutionalPageDto institutionalPageDto = moderationService.changeInstitutionalPageModerationStatus(
                institutionalPageId,
                inputModerationStatusDto
        );
        return new ResponseEntity<>(institutionalPageDto, HttpStatus.OK);
    }

}
