/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutional_page.bs.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2AuthenticationException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.InstitutionalPageDmClient;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.CreateParagraphIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.InstitutionalPageIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.InstitutionalPageViewIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.ParagraphIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.UpdateParagraphIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputParagraphDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.mapper.InstitutionalPageMapper;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.mapper.ParagraphMapper;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.InstitutionalPageProducer;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.NotificationMessageFactory;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.NotificationProducer;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.service.ParagraphService;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import feign.FeignException;
import java.util.NoSuchElementException;
import java.util.UUID;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class DefaultParagraphService
implements ParagraphService {
    private final ParagraphMapper paragraphMapper;
    private final InstitutionalPageMapper institutionalPageMapper;
    private final InstitutionalPageDmClient institutionalPageDmClient;
    private final NotificationMessageFactory notificationMessageFactory;
    private final NotificationProducer notificationProducer;
    private final InstitutionalPageProducer institutionalPageProducer;

    public OutputInstitutionalPageDto createParagraph(UUID institutionalPageId, InputParagraphDto paragraphDto, Integer position) {
        try {
            CreateParagraphIPDmDto paragraphDmDto = this.paragraphMapper.toCreateParagraphIPDmDto(paragraphDto);
            InstitutionalPageIPDmDto institutionalPageDmDto = this.institutionalPageDmClient.createParagraph(institutionalPageId, paragraphDmDto, position);
            OutputInstitutionalPageDto outputInstitutionalPageDto = this.institutionalPageMapper.toOutputInstitutionalPageDto(institutionalPageDmDto, true);
            MessagingEventDto notificationMessage = this.notificationMessageFactory.createParagraphCreatedNotification(paragraphDto, outputInstitutionalPageDto);
            this.notificationProducer.publishParagraphCreatedNotification(notificationMessage);
            InstitutionalPageIPDmDto originalInstitutionalPageDmDto = this.retrieveApprovedInstitutionalPageById(institutionalPageId);
            OutputInstitutionalPageDto originalOutputInstitutionalPageDto = this.institutionalPageMapper.toOutputInstitutionalPageDto(originalInstitutionalPageDmDto, true);
            this.institutionalPageProducer.publishUpdateEvent(originalOutputInstitutionalPageDto);
            return outputInstitutionalPageDto;
        }
        catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException(e.getMessage());
        }
        catch (FeignException.NotFound e) {
            throw new WP2ResourceNotFoundException((Throwable)e);
        }
        catch (FeignException e) {
            throw new WP2BusinessException((Throwable)e);
        }
    }

    public OutputInstitutionalPageDto updateParagraph(UUID institutionalPageId, UUID paragraphId, InputParagraphDto paragraphDto) {
        try {
            UpdateParagraphIPDmDto paragraphDmDto = this.paragraphMapper.toUpdateParagraphIPDmDto(paragraphDto);
            InstitutionalPageIPDmDto institutionalPageDmDto = this.institutionalPageDmClient.updateParagraph(institutionalPageId, paragraphId, paragraphDmDto);
            OutputInstitutionalPageDto outputInstitutionalPageDto = this.institutionalPageMapper.toOutputInstitutionalPageDto(institutionalPageDmDto, true);
            MessagingEventDto notificationMessage = this.notificationMessageFactory.createParagraphUpdatedNotification(paragraphDto, outputInstitutionalPageDto);
            this.notificationProducer.publishParagraphUpdatedNotification(notificationMessage);
            InstitutionalPageIPDmDto originalInstitutionalPageDmDto = this.retrieveApprovedInstitutionalPageById(institutionalPageId);
            OutputInstitutionalPageDto originalOutputInstitutionalPageDto = this.institutionalPageMapper.toOutputInstitutionalPageDto(originalInstitutionalPageDmDto, true);
            this.institutionalPageProducer.publishUpdateEvent(originalOutputInstitutionalPageDto);
            return outputInstitutionalPageDto;
        }
        catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException(e.getMessage());
        }
        catch (FeignException.NotFound e) {
            throw new WP2ResourceNotFoundException(e.getMessage());
        }
        catch (FeignException e) {
            throw new WP2BusinessException((Throwable)e);
        }
    }

    public OutputInstitutionalPageDto deleteParagraph(UUID institutionalPageId, UUID paragraphId) {
        try {
            ParagraphIPDmDto paragraphIPDmDto = this.institutionalPageDmClient.getInstitutionalPageById(institutionalPageId, null, Boolean.valueOf(false)).getParagraphs().stream().filter(paragraph -> paragraph.getId().equals(paragraphId)).findAny().orElseThrow();
            InstitutionalPageIPDmDto institutionalPageDmDto = this.institutionalPageDmClient.deleteParagraph(institutionalPageId, paragraphId);
            OutputInstitutionalPageDto outputInstitutionalPageDto = this.institutionalPageMapper.toOutputInstitutionalPageDto(institutionalPageDmDto, true);
            MessagingEventDto notificationMessage = this.notificationMessageFactory.createParagraphDeletedNotification(InputParagraphDto.builder().title(paragraphIPDmDto.getTitle()).build(), outputInstitutionalPageDto);
            this.notificationProducer.publishParagraphDeletedNotification(notificationMessage);
            InstitutionalPageIPDmDto originalInstitutionalPageDmDto = this.retrieveApprovedInstitutionalPageById(institutionalPageId);
            OutputInstitutionalPageDto originalOutputInstitutionalPageDto = this.institutionalPageMapper.toOutputInstitutionalPageDto(originalInstitutionalPageDmDto, true);
            this.institutionalPageProducer.publishUpdateEvent(originalOutputInstitutionalPageDto);
            return outputInstitutionalPageDto;
        }
        catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException(e.getMessage());
        }
        catch (FeignException.NotFound e) {
            throw new WP2ResourceNotFoundException(e.getMessage());
        }
        catch (NoSuchElementException e) {
            throw new WP2ResourceNotFoundException(paragraphId);
        }
        catch (FeignException e) {
            throw new WP2BusinessException((Throwable)e);
        }
    }

    private InstitutionalPageIPDmDto retrieveApprovedInstitutionalPageById(UUID institutionalPageId) {
        return this.institutionalPageDmClient.getInstitutionalPageById(institutionalPageId, InstitutionalPageViewIPDmDto.APPROVED, Boolean.valueOf(false));
    }

    @Generated
    public DefaultParagraphService(ParagraphMapper paragraphMapper, InstitutionalPageMapper institutionalPageMapper, InstitutionalPageDmClient institutionalPageDmClient, NotificationMessageFactory notificationMessageFactory, NotificationProducer notificationProducer, InstitutionalPageProducer institutionalPageProducer) {
        this.paragraphMapper = paragraphMapper;
        this.institutionalPageMapper = institutionalPageMapper;
        this.institutionalPageDmClient = institutionalPageDmClient;
        this.notificationMessageFactory = notificationMessageFactory;
        this.notificationProducer = notificationProducer;
        this.institutionalPageProducer = institutionalPageProducer;
    }
}

