/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.CreateInstitutionalPageIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.CreateParagraphIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.InstitutionalPageIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.InstitutionalPageViewIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.InviteMembersIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.MembersInHierarchyIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.ModerationIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.ModerationStatusDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.OutputRequestUpdateDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.PatchIPInvitationRequestIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.PatchIPJoinRequestIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.PatchMembershipIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.PendingMemberRequestsIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.RemoveMembershipIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.SubmitJoinRequestIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.UpdateInstitutionalPageIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.UpdateParagraphIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputSearchForMemberInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputSearchModerationInstitutionalPageDto;
import jakarta.validation.Valid;
import java.util.Set;
import java.util.UUID;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

public interface InstitutionalPageDmClient {
    @GetMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}"})
    public InstitutionalPageIPDmDto getInstitutionalPageById(@PathVariable UUID var1, @RequestParam(name="view", required=false) InstitutionalPageViewIPDmDto var2, @RequestParam(name="includePublishedAndNotMember", required=false) Boolean var3);

    @GetMapping(value={"/institutional-page/institutional-pages"})
    public OutputPageDto<InstitutionalPageIPDmDto> getAllInstitutionalPages(@RequestParam(name="view", required=false) InstitutionalPageViewIPDmDto var1, @RequestParam(name="includePublishedAndNotMember", required=false) Boolean var2, @RequestParam(name="associationsToLoad") Set<String> var3, @RequestParam(name="pageNumber") int var4, @RequestParam(name="pageSize") int var5, @RequestParam(name="sort") String var6, @RequestParam(name="direction") SortDirection var7);

    @PostMapping(value={"/institutional-page/institutional-pages"})
    public InstitutionalPageIPDmDto createInstitutionalPage(@RequestBody CreateInstitutionalPageIPDmDto var1);

    @PutMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}"})
    public InstitutionalPageIPDmDto updateInstitutionalPage(@PathVariable UUID var1, @RequestBody UpdateInstitutionalPageIPDmDto var2);

    @DeleteMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}"})
    public InstitutionalPageIPDmDto deleteInstitutionalPage(@PathVariable UUID var1);

    @PostMapping(value={"/institutional-page/institutional-pages/search"}, consumes={"application/json"}, produces={"application/json"})
    public OutputPageDto<InstitutionalPageIPDmDto> search(@RequestParam(name="view", required=false) InstitutionalPageViewIPDmDto var1, @RequestBody InputSearchForMemberInstitutionalPageDto var2, @RequestParam(name="associationsToLoad") Set<String> var3, @RequestParam(name="pageNumber") int var4, @RequestParam(name="pageSize") int var5, @RequestParam(name="sort") String var6, @RequestParam(name="direction") SortDirection var7);

    @PostMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/paragraphs"})
    public InstitutionalPageIPDmDto createParagraph(@PathVariable UUID var1, @RequestBody CreateParagraphIPDmDto var2, @RequestParam Integer var3);

    @PutMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/paragraphs/{paragraphId}"})
    public InstitutionalPageIPDmDto updateParagraph(@PathVariable UUID var1, @PathVariable UUID var2, @RequestBody UpdateParagraphIPDmDto var3);

    @DeleteMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/paragraphs/{paragraphId}"})
    public InstitutionalPageIPDmDto deleteParagraph(@PathVariable UUID var1, @PathVariable UUID var2);

    @PutMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/request-moderation"})
    public InstitutionalPageIPDmDto requestModerationInstitutionalPageById(@PathVariable UUID var1);

    @PutMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/request-publication"})
    public InstitutionalPageIPDmDto requestPublicationInstitutionalPageById(@PathVariable UUID var1);

    @GetMapping(path={"/institutional-page/institutional-pages/moderation"}, produces={"application/json"})
    public OutputPageDto<InstitutionalPageIPDmDto> getModerationInstitutionalPages(@RequestParam(name="associationsToLoad") Set<String> var1, @RequestParam(name="pageNumber", defaultValue="0", required=false) int var2, @RequestParam(name="pageSize", defaultValue="10", required=false) int var3, @RequestParam(name="sort", defaultValue="name", required=false) String var4, @RequestParam(name="direction", defaultValue="ASC", required=false) SortDirection var5);

    @GetMapping(value={"/institutional-page/institutional-pages/moderation/{institutionalPageId}"})
    public InstitutionalPageIPDmDto getModerationInstitutionalPageById(@PathVariable UUID var1);

    @PatchMapping(value={"/institutional-page/institutional-pages/moderation/{institutionalPageId}"})
    public ModerationIPDmDto changeInstitutionalPageModerationStatus(@PathVariable UUID var1, @Valid @RequestBody ModerationStatusDmDto var2);

    @GetMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/members/requests"}, produces={"application/json"})
    public PendingMemberRequestsIPDmDto findPendingMemberRequestsForInstitutionalPage(@PathVariable(value="institutionalPageId") UUID var1);

    @GetMapping(value={"/institutional-page/institutional-pages/members/requests"}, produces={"application/json"})
    public PendingMemberRequestsIPDmDto findPendingMemberRequestsForUser();

    @PostMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/members/requests/invitations"}, consumes={"application/json"}, produces={"application/json"})
    public PendingMemberRequestsIPDmDto inviteMembers(@PathVariable(value="institutionalPageId") UUID var1, @Valid @RequestBody InviteMembersIPDmDto var2);

    @DeleteMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/members/requests/invitations/{invitedUserId}"}, produces={"application/json"})
    public PendingMemberRequestsIPDmDto cancelInvitation(@PathVariable(value="institutionalPageId") UUID var1, @PathVariable(value="invitedUserId") UUID var2);

    @PatchMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/members/requests/invitations"}, produces={"application/json"})
    public PendingMemberRequestsIPDmDto acceptOrRejectInvitation(@PathVariable(value="institutionalPageId") UUID var1, @Valid @RequestBody PatchIPInvitationRequestIPDmDto var2);

    @PatchMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/members/membership"}, consumes={"application/json"}, produces={"application/json"})
    public InstitutionalPageIPDmDto patchMembershipOfUsersForInstitutionalPage(@PathVariable(value="institutionalPageId") UUID var1, @Valid @RequestBody PatchMembershipIPDmDto var2);

    @DeleteMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/members/membership"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public InstitutionalPageIPDmDto removeMembershipOfUsersForInstitutionalPage(@PathVariable(value="institutionalPageId") UUID var1, @Valid @RequestBody RemoveMembershipIPDmDto var2);

    @PostMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/members/requests/join"}, consumes={"application/json"}, produces={"application/json"})
    public PendingMemberRequestsIPDmDto submitJoinRequest(@PathVariable(value="institutionalPageId") UUID var1, @Valid @RequestBody SubmitJoinRequestIPDmDto var2);

    @DeleteMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/members/requests/join"}, produces={"application/json"})
    public PendingMemberRequestsIPDmDto cancelJoinRequest(@PathVariable(value="institutionalPageId") UUID var1);

    @PatchMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/members/requests/join"}, consumes={"application/json"}, produces={"application/json"})
    public PendingMemberRequestsIPDmDto acceptOrRejectJoinRequests(@PathVariable(value="institutionalPageId") UUID var1, @Valid @RequestBody PatchIPJoinRequestIPDmDto var2);

    @GetMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/hierarchy"}, produces={"application/json"})
    public OutputPageDto<InstitutionalPageIPDmDto> findInstitutionalPagesHierarchyByRootId(@PathVariable(value="institutionalPageId") UUID var1, @RequestParam(name="associationsToLoad", defaultValue="all", required=false) Set<String> var2, @RequestParam(name="pageNumber", defaultValue="0", required=false) int var3, @RequestParam(name="pageSize", defaultValue="10", required=false) int var4, @RequestParam(name="sort", defaultValue="id", required=false) String var5, @RequestParam(name="direction", defaultValue="ASC", required=false) SortDirection var6);

    @GetMapping(value={"/institutional-page/institutional-pages/{rootInstitutionalPageId}/members/hierarchy"}, produces={"application/json"})
    public OutputPageDto<MembersInHierarchyIPDmDto> findAllUsersInHierarchy(@PathVariable(value="rootInstitutionalPageId") UUID var1, @RequestParam(name="pageNumber", defaultValue="0", required=false) int var2, @RequestParam(name="pageSize", defaultValue="10", required=false) int var3);

    @PostMapping(value={"/institutional-page/institutional-pages/moderation/search"}, consumes={"application/json"}, produces={"application/json"})
    public OutputPageDto<InstitutionalPageIPDmDto> searchModerationInstitutionalPages(@RequestBody InputSearchModerationInstitutionalPageDto var1, @RequestParam(name="associationsToLoad") Set<String> var2, @RequestParam(name="pageNumber", defaultValue="0", required=false) int var3, @RequestParam(name="pageSize", defaultValue="10", required=false) int var4, @RequestParam(name="sort", defaultValue="name", required=false) String var5, @RequestParam(name="direction", defaultValue="ASC", required=false) SortDirection var6);

    @GetMapping(value={"/institutional-page/admin"}, produces={"application/json"})
    public Boolean isAdmin();

    @PutMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/folders/{newFolderId}"}, produces={"application/json"})
    public InstitutionalPageIPDmDto updateFolderId(@PathVariable(value="institutionalPageId") UUID var1, @PathVariable(value="newFolderId") UUID var2);

    @PutMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/request-update"}, produces={"application/json"})
    public OutputRequestUpdateDmDto requestUpdateInstitutionalPageById(@PathVariable(value="institutionalPageId") UUID var1);

    @PutMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/cancel-update"})
    public void cancelUpdateInstitutionalPageById(@PathVariable(value="institutionalPageId") UUID var1);
}

