package com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging;

import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.InstitutionalPageCreatedNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.InstitutionalPageDeletedNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.InstitutionalPageModerationRequestNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.InstitutionalPagePublicationRequestNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.InstitutionalPageUpdatedNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.InstitutionalPageStatusChangeNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.MembershipRemovalNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.ParagraphCreatedNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.ParagraphUpdatedNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.ParagraphDeletedNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.MemberInvitationNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.MemberInvitationStatusChangeNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.JoinRequestNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.JoinRequestStatusChangeNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.MembershipChangeNotificationData;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;

/**
 * Message Producer responsible for publishing institutional-pages notifications
 */
public interface NotificationProducer {
    /**
     * Publishes a notification signaling the creation of an institutional page.
     *
     * @param message the message body containing details about the created institutional page
     */
    void publishInstitutionalPageCreatedNotification(MessagingEventDto<InstitutionalPageCreatedNotificationData> message);

    /**
     * Publishes a notification signaling the update of an institutional page.
     *
     * @param message the message body containing details about the updated institutional page
     */
    void publishInstitutionalPageUpdatedNotification(MessagingEventDto<InstitutionalPageUpdatedNotificationData> message);

    /**
     * Publishes a notification signaling the deletion of an institutional page.
     *
     * @param message the message body containing details about the deleted institutional page
     */
    void publishInstitutionalPageDeletedNotification(MessagingEventDto<InstitutionalPageDeletedNotificationData> message);

    /**
     * Publishes a notification signaling a moderation status change (approval/rejection) of an institutional page.
     *
     * @param message the message body containing details about the status change of the institutional page
     */
    void publishInstitutionalPageStatusChangeNotification(MessagingEventDto<InstitutionalPageStatusChangeNotificationData> message);

    /**
     * Publishes a notification signaling a request for the moderation of an institutional page.
     *
     * @param message the message body containing details about the institutional page moderation request
     */
    void publishInstitutionalPageModerationRequestNotification(MessagingEventDto<InstitutionalPageModerationRequestNotificationData> message);

    /**
     * Publishes a notification signaling a request for the publication of an institutional page.
     *
     * @param message the message body containing details about the institutional page publication request
     */
    void publishInstitutionalPagePublicationRequestNotification(MessagingEventDto<InstitutionalPagePublicationRequestNotificationData> message);

    /**
     * Publishes a notification signaling a new join request to an institutional page.
     *
     * @param message the message body containing details about the join request
     */
    void publishJoinRequestNotification(MessagingEventDto<JoinRequestNotificationData> message);

    /**
     * Publishes a notification signaling the deletion of a join request.
     *
     * @param message the message body containing details about the deleted join request
     */
    void publishJoinRequestDeletedNotification(MessagingEventDto<JoinRequestNotificationData> message);

    /**
     * Publishes a notification signaling a status change (approval/rejection) of a join request.
     *
     * @param message the message body containing details about the join request status change
     */
    void publishJoinRequestStatusChangeNotification(MessagingEventDto<JoinRequestStatusChangeNotificationData> message);

    /**
     * Publishes a notification signaling a new member invitation to an institutional page.
     *
     * @param message the message body containing details about the member invitation
     */
    void publishMemberInvitationNotification(MessagingEventDto<MemberInvitationNotificationData> message);

    /**
     * Publishes a notification signaling the deletion of a member invitation.
     *
     * @param message the message body containing details about the deleted member invitation
     */
    void publishMemberInvitationDeletedNotification(MessagingEventDto<MemberInvitationNotificationData> message);

    /**
     * Publishes a notification signaling a status change (acceptance/rejection) of a member invitation.
     *
     * @param message the message body containing details about the member invitation status change
     */
    void publishMemberInvitationStatusChangeNotification(MessagingEventDto<MemberInvitationStatusChangeNotificationData> message);

    /**
     * Publishes a notification signaling a change in membership status or role within an institutional page.
     *
     * @param message the message body containing details about the membership change
     */
    void publishMembershipChangeNotification(MessagingEventDto<MembershipChangeNotificationData> message);

    /**
     * Publishes a notification signaling the removal of membership an institutional page.
     *
     * @param message the message body containing details about the membership removal
     */
    void publishMembershipRemovalNotification(MessagingEventDto<MembershipRemovalNotificationData> message);

    /**
     * Publishes a notification signaling the creation of a new paragraph in an institutional page.
     *
     * @param message the message body containing details about the created paragraph
     */
    void publishParagraphCreatedNotification(MessagingEventDto<ParagraphCreatedNotificationData> message);

    /**
     * Publishes a notification signaling the update of a paragraph in an institutional page.
     *
     * @param message the message body containing details about the updated paragraph
     */
    void publishParagraphUpdatedNotification(MessagingEventDto<ParagraphUpdatedNotificationData> message);

    /**
     * Publishes a notification signaling the deletion of a paragraph from an institutional page.
     *
     * @param message the message body containing details about the deleted paragraph
     */
    void publishParagraphDeletedNotification(MessagingEventDto<ParagraphDeletedNotificationData> message);
}
