package com.finconsgroup.itserr.marketplace.institutional_page.bs.mapper;

import com.finconsgroup.itserr.marketplace.catalog.bs.dto.OutputAuthorDto;
import com.finconsgroup.itserr.marketplace.catalog.bs.dto.OutputItemDto;
import com.finconsgroup.itserr.marketplace.catalog.bs.dto.OutputTypeDto;
import com.finconsgroup.itserr.marketplace.catalog.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputPublicationAuthorDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputPublicationDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputPublicationUserProfileDto;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2026-02-06T15:24:13+0000",
    comments = "version: 1.6.3, compiler: javac, environment: Java 21.0.9 (Eclipse Adoptium)"
)
@Component
public class PublicationMapperImpl implements PublicationMapper {

    @Override
    public OutputPublicationDto toOutputPublicationDto(OutputItemDto dto) {
        if ( dto == null ) {
            return null;
        }

        OutputPublicationDto.OutputPublicationDtoBuilder outputPublicationDto = OutputPublicationDto.builder();

        outputPublicationDto.type( dtoTypeName( dto ) );
        LocalDate date = dtoPublicationDate( dto );
        if ( date != null ) {
            outputPublicationDto.publicationDate( date.atStartOfDay() );
        }
        outputPublicationDto.id( dto.getId() );
        outputPublicationDto.title( dto.getTitle() );
        outputPublicationDto.description( dto.getDescription() );
        outputPublicationDto.status( itemStatusToString( dto.getStatus() ) );
        outputPublicationDto.authors( outputAuthorDtoListToOutputPublicationAuthorDtoList( dto.getAuthors() ) );
        outputPublicationDto.maintainer( outputUserProfileDtoToOutputPublicationUserProfileDto( dto.getMaintainer() ) );
        outputPublicationDto.createdAt( dto.getCreatedAt() );
        outputPublicationDto.updatedAt( dto.getUpdatedAt() );
        outputPublicationDto.imageUrl( dto.getImageUrl() );
        outputPublicationDto.license( dto.getLicense() );
        List<String> list1 = dto.getTags();
        if ( list1 != null ) {
            outputPublicationDto.tags( new ArrayList<String>( list1 ) );
        }
        outputPublicationDto.language( dto.getLanguage() );

        return outputPublicationDto.build();
    }

    private String dtoTypeName(OutputItemDto outputItemDto) {
        OutputTypeDto type = outputItemDto.getType();
        if ( type == null ) {
            return null;
        }
        return type.getName();
    }

    private LocalDate dtoPublicationDate(OutputItemDto outputItemDto) {
        com.finconsgroup.itserr.marketplace.catalog.bs.dto.OutputPublicationDto publication = outputItemDto.getPublication();
        if ( publication == null ) {
            return null;
        }
        return publication.getDate();
    }

    protected OutputPublicationAuthorDto outputAuthorDtoToOutputPublicationAuthorDto(OutputAuthorDto outputAuthorDto) {
        if ( outputAuthorDto == null ) {
            return null;
        }

        OutputPublicationAuthorDto.OutputPublicationAuthorDtoBuilder outputPublicationAuthorDto = OutputPublicationAuthorDto.builder();

        outputPublicationAuthorDto.id( outputAuthorDto.getId() );
        outputPublicationAuthorDto.firstName( outputAuthorDto.getFirstName() );
        outputPublicationAuthorDto.lastName( outputAuthorDto.getLastName() );
        outputPublicationAuthorDto.email( outputAuthorDto.getEmail() );
        outputPublicationAuthorDto.orcid( outputAuthorDto.getOrcid() );

        return outputPublicationAuthorDto.build();
    }

    protected List<OutputPublicationAuthorDto> outputAuthorDtoListToOutputPublicationAuthorDtoList(List<OutputAuthorDto> list) {
        if ( list == null ) {
            return null;
        }

        List<OutputPublicationAuthorDto> list1 = new ArrayList<OutputPublicationAuthorDto>( list.size() );
        for ( OutputAuthorDto outputAuthorDto : list ) {
            list1.add( outputAuthorDtoToOutputPublicationAuthorDto( outputAuthorDto ) );
        }

        return list1;
    }

    protected OutputPublicationUserProfileDto outputUserProfileDtoToOutputPublicationUserProfileDto(OutputUserProfileDto outputUserProfileDto) {
        if ( outputUserProfileDto == null ) {
            return null;
        }

        OutputPublicationUserProfileDto.OutputPublicationUserProfileDtoBuilder outputPublicationUserProfileDto = OutputPublicationUserProfileDto.builder();

        outputPublicationUserProfileDto.id( outputUserProfileDto.getId() );
        outputPublicationUserProfileDto.firstName( outputUserProfileDto.getFirstName() );
        outputPublicationUserProfileDto.lastName( outputUserProfileDto.getLastName() );
        outputPublicationUserProfileDto.email( outputUserProfileDto.getEmail() );
        outputPublicationUserProfileDto.preferredUsername( outputUserProfileDto.getPreferredUsername() );
        outputPublicationUserProfileDto.orcid( outputUserProfileDto.getOrcid() );

        return outputPublicationUserProfileDto.build();
    }
}
