package com.finconsgroup.itserr.marketplace.institutional_page.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.List;
import java.util.UUID;

import static com.finconsgroup.itserr.marketplace.institutional_page.bs.util.Constants.VALIDATION_ERROR_FIELD_IP_CATEGORY_ALLOWED_VALUES;
import static com.finconsgroup.itserr.marketplace.institutional_page.bs.util.Constants.VALIDATION_ERROR_FIELD_IP_PENDING_MODERATION_STATUS_ALLOWED_VALUES;

/**
 * Input DTO for searching Pending institutionalPages.
 */
@Schema(
        name = "InputSearchPendingInstitutionalPageDto",
        description = "Input DTO for searching Pending institutionalPages"
)
@Data
@Builder
@AllArgsConstructor
public class InputSearchModerationInstitutionalPageDto {

    /**
     * Filter to only return institutional pages matching the provided ids.
     */
    @Schema(
            description = "The ids of the institutional page, if present it should have at least one entry",
            example = "[\"11111111-aaaa-0000-0000-000000000000\"]"
    )
    @Size(min = 1)
    private List<UUID> ids;

    /**
     * Filter to only return institutional pages matching the provided category
     */
    @Schema(
            description = "The category of the institutional page",
            allowableValues = {"tool", "project"},
            example = "project"
    )
    @Pattern(regexp = "tool|project", message = VALIDATION_ERROR_FIELD_IP_CATEGORY_ALLOWED_VALUES)
    private String category;

    /**
     * Filter to only return root level i.e. top level institutional pages
     */
    @Schema(
            description = "The flag to indicate if only top level institutional pages should be returned",
            example = "true"
    )
    private Boolean rootLevelOnly;

    /**
     * The text used to filter institutional pages by name
     */
    @Schema(
            description = "The text used to filter institutional pages by name",
            example = "T-Res"
    )
    private String searchText;

    /**
     * Filter to only return published institutional pages
     */
    @Schema(
            description = "The flag to indicate if published institutional pages",
            example = "true"
    )
    private Boolean published;

    /**
     * Filter to only return institutional pages matching the provided moderation status
     */
    @Schema(
            description = "The moderation status of the institutional page",
            allowableValues = {"Pending", "Rejected"},
            example = "Pending"
    )
    @Pattern(regexp = "Pending|Rejected", message = VALIDATION_ERROR_FIELD_IP_PENDING_MODERATION_STATUS_ALLOWED_VALUES)
    private String moderationStatus;

}
