package com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.time.LocalDate;

/**
 * Output Dto of a publication information including date and location of catalog item.
 */
@Schema(name = "PublicationCatalogBsDto",
        description = "Output Dto of a publication information including date and location of catalog item")
@Data
@Builder
@AllArgsConstructor
public class PublicationCatalogBsDto {

    @Schema(description = "Publication date", example = "2025-11-14", requiredMode = Schema.RequiredMode.REQUIRED)
    private LocalDate date;

    @Schema(description = "ZIP or postal code", example = "12345")
    private String zipCode;

    @Schema(description = "City name", example = "Milan")
    private String city;

    @Schema(description = "Region or state name", example = "Lombardy")
    private String region;

    @Schema(description = "Country name", example = "Italy")
    private String country;

}
