package com.finconsgroup.itserr.marketplace.institutional_page.bs;

import com.finconsgroup.itserr.marketplace.institutional_page.bs.config.properties.InstitutionalPageBsConfigurationProperties;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.config.properties.WorkspaceBsConfigurationProperties;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.info.Info;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@SpringBootApplication
@OpenAPIDefinition(info = @Info(
        title = "Institutional-page BS API",
        description = "API definition of the Institutional-page Microservice",
        version = "1.0.0"
))
@EnableConfigurationProperties({
        InstitutionalPageBsConfigurationProperties.class,
        WorkspaceBsConfigurationProperties.class
})
public class InstitutionalPageBsApplication {
    public static void main(String[] args) {
        SpringApplication.run(InstitutionalPageBsApplication.class, args);
    }
}
