/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutional_page.bs.mapper;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.dto.OutputItemDtoWorkspaceBsDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.CreateInstitutionalPageIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.InstitutionalPageIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.ModerationStatusIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.OutputRequestUpdateDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.UpdateInstitutionalPageIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputCreateInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputUpdateInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.ModerationStatus;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputRequestUpdateDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputWorkspaceItemDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.mapper.InstitutionalPagePartialMapper;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.repository.CatalogRepository;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.repository.UserProfileRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class InstitutionalPageMapper {
    private final InstitutionalPagePartialMapper partialMapper;
    private final UserProfileRepository userProfileRepository;
    private final CatalogRepository catalogRepository;

    public CreateInstitutionalPageIPDmDto toCreateInstitutionalPageDmDto(InputCreateInstitutionalPageDto dto, UUID workspaceFolderId) {
        CreateInstitutionalPageIPDmDto dmDto = this.partialMapper.toCreateInstitutionalPageDmDto(dto);
        dmDto.setWorkspaceFolderId(workspaceFolderId);
        return dmDto;
    }

    public CreateInstitutionalPageIPDmDto toCreateInstitutionalPageDmDto(InputCreateInstitutionalPageDto dto, UUID workspaceFolderId, String imageUrl) {
        CreateInstitutionalPageIPDmDto dmDto = this.partialMapper.toCreateInstitutionalPageDmDto(dto);
        dmDto.setWorkspaceFolderId(workspaceFolderId);
        dmDto.setImageUrl(imageUrl);
        return dmDto;
    }

    public UpdateInstitutionalPageIPDmDto toUpdateInstitutionalPageDmDto(InputUpdateInstitutionalPageDto dto, String imageUrl) {
        UpdateInstitutionalPageIPDmDto dmDto = this.partialMapper.toUpdateInstitutionalPageDmDto(dto);
        dmDto.setImageUrl(imageUrl);
        return dmDto;
    }

    public OutputInstitutionalPageDto toOutputInstitutionalPageDto(InstitutionalPageIPDmDto dto, boolean withPublications) {
        OutputInstitutionalPageDto outputDto = this.partialMapper.toOutputInstitutionalPageDto(dto);
        List memberProfiles = this.userProfileRepository.getMemberProfilesOrThrow(dto.getMembers());
        List wpLeadsProfiles = this.userProfileRepository.getMemberProfilesOrThrow(dto.getWpLeads());
        OutputUserProfileDto maintainer = null;
        if (dto.getMaintainer() != null) {
            maintainer = (OutputUserProfileDto)this.userProfileRepository.getMemberProfilesOrThrow(List.of(dto.getMaintainer())).getFirst();
        }
        OutputUserProfileDto updateLockedBy = null;
        if (dto.getUpdateLockedBy() != null) {
            updateLockedBy = (OutputUserProfileDto)this.userProfileRepository.getMemberProfilesOrThrow(List.of(dto.getUpdateLockedBy())).getFirst();
        }
        OutputUserProfileDto lastModifiedBy = null;
        if (dto.getLastModifiedBy() != null) {
            lastModifiedBy = (OutputUserProfileDto)this.userProfileRepository.getMemberProfilesOrThrow(List.of(dto.getLastModifiedBy())).getFirst();
        }
        List publications = List.of();
        if (withPublications) {
            publications = this.catalogRepository.getPublications(dto.getId());
        }
        outputDto.setMembers(memberProfiles);
        outputDto.setWpLeads(wpLeadsProfiles);
        outputDto.setMaintainer(maintainer);
        outputDto.setUpdateLockedBy(updateLockedBy);
        outputDto.setLastModifiedBy(lastModifiedBy);
        outputDto.setPublications(publications);
        return outputDto;
    }

    public OutputPageDto<OutputInstitutionalPageDto> toOutputPageDto(OutputPageDto<InstitutionalPageIPDmDto> dto) {
        return this.toOutputPageDto(dto, true);
    }

    public OutputPageDto<OutputInstitutionalPageDto> toOutputPageDto(OutputPageDto<InstitutionalPageIPDmDto> dto, boolean withPublications) {
        ArrayList<OutputInstitutionalPageDto> institutionalPages = new ArrayList<OutputInstitutionalPageDto>();
        for (InstitutionalPageIPDmDto institutionalPageDmDto : dto.getContent()) {
            institutionalPages.add(this.toOutputInstitutionalPageDto(institutionalPageDmDto, withPublications));
        }
        OutputPageDto outputPage = new OutputPageDto();
        outputPage.setContent(institutionalPages);
        outputPage.setPage(dto.getPage());
        return outputPage;
    }

    public OutputWorkspaceItemDto toOutputWorkspaceItemDto(OutputItemDtoWorkspaceBsDto src) {
        return this.partialMapper.toOutputWorkspaceItemDto(src);
    }

    public OutputRequestUpdateDto toOutputRequestUpdateDto(OutputRequestUpdateDmDto src) {
        return this.partialMapper.toOutputRequestUpdateDto(src);
    }

    public ModerationStatusIPDmDto toModerationStatusIPDmDto(ModerationStatus src) {
        return this.partialMapper.toModerationStatusIPDmDto(src);
    }

    @Generated
    public InstitutionalPageMapper(InstitutionalPagePartialMapper partialMapper, UserProfileRepository userProfileRepository, CatalogRepository catalogRepository) {
        this.partialMapper = partialMapper;
        this.userProfileRepository = userProfileRepository;
        this.catalogRepository = catalogRepository;
    }
}

