package com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs;

import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.dto.UserProfileBsDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputUserProfileDto;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

public interface UserProfileBsClient {

    /**
     * Get the user profiles matching the provided role.
     *
     * @param roleName the role name to search for
     * @return the list of matching {@link OutputUserProfileDto} and HTTP status 200 (OK)
     */
    @GetMapping(value = "/profiles-by-role", produces = MediaType.APPLICATION_JSON_VALUE)
    List<UserProfileBsDto> getUserProfilesByRole(
            @RequestParam("roleName") String roleName
    );
}
