package com.finconsgroup.itserr.marketplace.institutional_page.bs.service;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputModerationStatusDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputSearchPendingInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageDto;

import java.util.Set;
import java.util.UUID;

public interface ModerationService {

    /**
     * Get all pending institutional pages
     *
     * @param associationsToLoad the associations to be returned on the response
     * @param pageNumber the page number
     * @param pageSize the size of the page
     * @param sort the attribute to sort by
     * @param direction the sorting direction (ASC or DESC)
     * @return the pending institutional pages
     */
    OutputPageDto<OutputInstitutionalPageDto> getPendingInstitutionalPages(Set<String> associationsToLoad, int pageNumber, int pageSize, String sort, SortDirection direction);

    /**
     * Get pending institutional page by id
     *
     * @param institutionalPageId the id of the institutional page
     * @return the pending institutional page
     */
    OutputInstitutionalPageDto getPendingInstitutionalPageById(UUID institutionalPageId);

    /**
     * Approve or reject an institutional page
     *
     * @param institutionalPageId the id of the institutional page
     * @return the approved/rejected institutional page
     */
    OutputInstitutionalPageDto changeInstitutionalPageModerationStatus(UUID institutionalPageId, InputModerationStatusDto inputModerationStatusDto);

    /**
     * Search the latest version of pending institutional pages
     *
     * @param inputSearchPendingInstitutionalPageDto the search criteria
     * @param associationsToLoad the associations to be returned on the response
     * @param pageNumber the page number
     * @param pageSize the size of the page
     * @param sort the attribute to sort by
     * @param direction the sorting direction (ASC or DESC)
     * @return the matching pending institutional pages
     */
    OutputPageDto<OutputInstitutionalPageDto> searchLatestVersionPendingInstitutionalPages(
            InputSearchPendingInstitutionalPageDto inputSearchPendingInstitutionalPageDto,
            Set<String> associationsToLoad,
            int pageNumber,
            int pageSize,
            String sort,
            SortDirection direction
    );

    /**
     * Requests the publication of an institutional page by its ID.
     *
     * @param institutionalPageId the UUID of the institutional page to be published
     * @return the details of the institutional page after the publication request
     */
    OutputInstitutionalPageDto requestPublishInstitutionalPage(UUID institutionalPageId);
}
