package com.finconsgroup.itserr.marketplace.institutional_page.bs.dto;

import com.fasterxml.jackson.annotation.JsonValue;

public enum OutputWorkspaceUploadType {

    FILE_SYSTEM("FILE_SYSTEM"), NOTE("NOTE"), LINK("LINK");

    private final String label;

    OutputWorkspaceUploadType(String label) {
        this.label = label;
    }

    @JsonValue
    public String getLabel() {
        return label;
    }

    /**
     * It maps the label to a {@link OutputWorkspaceUploadType} object
     *
     * @param label the label to map to enum
     * @return {@link OutputWorkspaceUploadType} instance if found
     * @throws IllegalArgumentException if no matching instance found
     */
    public static OutputWorkspaceUploadType ofLabel(String label) {
        for (OutputWorkspaceUploadType outputWorkspaceUploadType : OutputWorkspaceUploadType.values()) {
            if (outputWorkspaceUploadType.label.equalsIgnoreCase(label)) {
                return outputWorkspaceUploadType;
            }
        }

        throw new IllegalArgumentException("Unsupported value: " + label);
    }
}
