package com.finconsgroup.itserr.marketplace.institutional_page.bs.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.CVUserProfileDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.ExpertiseDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.WorkingLocationUserProfileDmDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.UUID;

@Schema(name = "OutputUserProfileDto", description = "Output DTO of a user profile")
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class OutputUserProfileDto {
    private UUID id;
    private String firstName;
    private String lastName;
    private String email;
    private String preferredUsername;
    private boolean userExists;
    private UUID userProfileFolderId;
    private String imageUrl;
    private CVUserProfileDmDto cv;
    private String orcid;
    private boolean openToCollaboration;
    private boolean showPublicEmail;
    private String personalWebsite;
    private String linkedinProfile;
    private String socialProfile;
    private String shortBio;
    private WorkingLocationUserProfileDmDto workingLocation;
    private String organizationAffiliation;
    private List<String> ssd;
    private List<ExpertiseDmDto> expertises;
    private List<Project> projects;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime creationTime;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime updateTime;

    private String language;

    @Data
    @Builder
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Project {
        private UUID projectId;
        private String displayName;
        private String wp;
        private UUID rootProjectId;
        private String rootProjectDisplayName;
    }
}
