package com.finconsgroup.itserr.marketplace.institutional_page.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.List;

/**
 * Output DTO of a member with association for each institutional page of a given hierarchy.
 */
@Data
@Builder
@AllArgsConstructor
@Schema(
        name = "OutputMembersInHierarchyDto",
        description = "Output DTO of a member with association for each institutional page of a given hierarchy"
)
public class OutputMembersInHierarchyDto {

    @Schema(
            description = "User profile of the user belonging to the institutional page hierarchy"
    )
    private OutputUserProfileDto user;

    @Schema(description = "The root institutional page")
    private OutputInstitutionalPageDto rootInstitutionalPage;

    @Schema(description = "DTO containing institutional page id and membership type for a specific member")
    private List<OutputInstitutionalPageForMembersInHierarchyDto> institutionalPages;

}
