package com.finconsgroup.itserr.marketplace.institutional_page.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import static com.finconsgroup.itserr.marketplace.institutional_page.bs.util.Constants.MAX_MEDIUM_TEXT_LENGTH;
import static com.finconsgroup.itserr.marketplace.institutional_page.bs.util.Constants.VALIDATION_ERROR_FIELD_LENGTH;


/**
 * Input DTO for submitting a join request.
 */
@Schema(name = "InputSubmitJoinRequestDto", description = "Input DTO for submitting a join request")
@Data
@Builder
@AllArgsConstructor
public class InputSubmitJoinRequestDto {

    @Schema(description = "The join message", example = "I would like to be a member of institutional page")
    @Size(max = MAX_MEDIUM_TEXT_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String message;

}
