package com.finconsgroup.itserr.marketplace.institutional_page.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.List;
import java.util.UUID;

import static com.finconsgroup.itserr.marketplace.institutional_page.bs.util.Constants.VALIDATION_ERROR_FIELD_IP_CATEGORY_ALLOWED_VALUES;

/**
 * Input DTO for searching institutionalPages.
 */
@Schema(name = "InputSearchForMemberInstitutionalPageDto", description = "Input DTO for searching institutionalPages")
@Data
@Builder
@AllArgsConstructor
public class InputSearchForMemberInstitutionalPageDto {

    /**
     * Filter to only return institutional pages matching the provided ids.
     */
    @Schema(
            description = "The ids of the institutional page, if present it should have at least one entry",
            example = "[\"11111111-aaaa-0000-0000-000000000000\"]"
    )
    @Size(min = 1)
    private List<UUID> ids;

    /**
     * Filter to only return private institutional pages for which the user is a member
     */
    @Schema(
            description = "The flag to indicate if private institutional pages for which the user is member should be returned",
            example = "true"
    )
    private Boolean includePrivateAndMember;

    /**
     * Filter to only return published institutional pages for which the user is a member
     */
    @Schema(
            description = "The flag to indicate if published institutional pages for which the user is member should be returned",
            example = "true"
    )
    private Boolean includePublishedAndMember;

    /**
     * Filter to only return published institutional pages for which the user is NOT a member
     */
    @Schema(
            description = "The flag to indicate if published institutional pages for which the user is NOT a member should be returned",
            example = "true"
    )
    private Boolean includePublishedAndNotMember;

    /**
     * Filter to only return institutional pages matching the provided category
     */
    @Schema(
            description = "The category of the institutional page",
            allowableValues = {"tool", "project"},
            example = "project"
    )
    @Pattern(regexp = "tool|project", message = VALIDATION_ERROR_FIELD_IP_CATEGORY_ALLOWED_VALUES)
    private String category;

    /**
     * Filter to only return root level i.e., top level institutional pages
     */
    @Schema(
            description = "The flag to indicate if only top level institutional pages should be returned",
            example = "true"
    )
    private Boolean rootLevelOnly;

    /**
     * Filter to only return institutional pages where the user is wp leader
     */
    @Schema(
            description = "Filter to only return institutional pages where the user is wp leader",
            example = "true"
    )
    private Boolean wpLeaderOnly;

    /**
     * The text used to filter institutional pages by name
     */
    @Schema(
            description = "The text used to filter institutional pages by name",
            example = "T-Res"
    )
    private String searchText;
}
