package com.finconsgroup.itserr.marketplace.institutional_page.bs.controller;

import com.finconsgroup.itserr.marketplace.institutional_page.bs.api.ParagraphApi;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputParagraphDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.service.ParagraphService;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

import java.util.UUID;

@RestController
@RequiredArgsConstructor
public class ParagraphController implements ParagraphApi {
    private final ParagraphService paragraphService;

    @Override
    public ResponseEntity<OutputInstitutionalPageDto> createParagraph(UUID institutionalPageId, InputParagraphDto paragraphDto, Integer position) {
        OutputInstitutionalPageDto institutionalPage = paragraphService.createParagraph(institutionalPageId, paragraphDto, position);
        return new ResponseEntity<>(institutionalPage, HttpStatus.CREATED);
    }

    @Override
    public ResponseEntity<OutputInstitutionalPageDto> updateParagraph(UUID institutionalPageId, UUID paragraphId, InputParagraphDto paragraphDto) {
        OutputInstitutionalPageDto institutionalPage = paragraphService.updateParagraph(institutionalPageId, paragraphId, paragraphDto);
        return new ResponseEntity<>(institutionalPage, HttpStatus.OK);
    }

    @Override
    public ResponseEntity<OutputInstitutionalPageDto> deleteParagraph(UUID institutionalPageId, UUID paragraphId) {
        OutputInstitutionalPageDto institutionalPage = paragraphService.deleteParagraph(institutionalPageId, paragraphId);
        return new ResponseEntity<>(institutionalPage, HttpStatus.OK);
    }
}
