package com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.InstitutionalPageIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputSearchPublishedInstitutionalPageDto;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Set;
import java.util.UUID;

public interface PublishedInstitutionalPageDmClient {

    /**
     * Get published institutional page by id
     * @param institutionalPageId the id of the institutional page
     * @return the institutional page dto
     */
    @GetMapping("/institutional-page/institutional-pages/published/{institutionalPageId}")
    InstitutionalPageIPDmDto getPublishedInstitutionalPageById(@PathVariable UUID institutionalPageId);

    /**
     * Get all published institutional pages for which the user is a contributor
     * @param pageNumber the page number
     * @param pageSize the size of the page
     * @param sort the attribute to sort by
     * @param direction the sorting direction (ASC or DESC)
     * @return the dto of the institutional page
     */
    @GetMapping("/institutional-page/institutional-pages/published")
    OutputPageDto<InstitutionalPageIPDmDto> getAllPublishedInstitutionalPages(
            @RequestParam(name = "associationsToLoad") Set<String> associationsToLoad,
            @RequestParam(name = "pageNumber") int pageNumber,
            @RequestParam(name = "pageSize") int pageSize,
            @RequestParam(name ="sort") String sort,
            @RequestParam(name = "direction") SortDirection direction
    );

    /**
     * Retrieves a paginated list of all published InstitutionalPages matching the search criteria.
     *
     * @param inputSearchInstitutionalPageDto the dto containing the filters to be applied
     * @param pageNumber                      the page number to retrieve (default is 0)
     * @param pageSize                        the number of InstitutionalPages per page (default is 10)
     * @param sort                            the field to sort by (default is "id")
     * @param direction                       the direction of sorting (default is ascending)
     * @return a page of {@link InstitutionalPageIPDmDto} and HTTP status 200 (OK)
     */
    @PostMapping(value = "/institutional-page/institutional-pages/published/search", consumes = MediaType.APPLICATION_JSON_VALUE,
            produces = MediaType.APPLICATION_JSON_VALUE)
    OutputPageDto<InstitutionalPageIPDmDto> searchPublished(
            @RequestBody InputSearchPublishedInstitutionalPageDto inputSearchInstitutionalPageDto,
            @RequestParam(name = "associationsToLoad") Set<String> associationsToLoad,
            @RequestParam(name = "pageNumber") int pageNumber,
            @RequestParam(name = "pageSize") int pageSize,
            @RequestParam(name = "sort") String sort,
            @RequestParam(name = "direction") SortDirection direction
    );
}
