/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.favourite.user.dm.controller;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.api.FavouriteUserItemApi;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.dto.InputCreateFavouriteUserItemDto;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.dto.InputPatchFavouriteUserItemDto;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.dto.OutputFavouriteUserItemDto;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.dto.OutputFavouriteUserItemSubscriberDto;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.enums.ItemContext;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.service.FavouriteUserItemService;
import java.beans.PropertyEditor;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FavouriteUserItemController
implements FavouriteUserItemApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FavouriteUserItemController.class);
    private final FavouriteUserItemService favouriteUserItemService;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringTrimmerEditor(false));
    }

    @NonNull
    public OutputFavouriteUserItemDto create(InputCreateFavouriteUserItemDto dto) {
        return this.favouriteUserItemService.create(JwtTokenHolder.getUserIdOrThrow(), dto);
    }

    @NonNull
    public OutputFavouriteUserItemDto get(UUID favouriteUserItemId) {
        return this.favouriteUserItemService.findById(JwtTokenHolder.getUserIdOrThrow(), favouriteUserItemId);
    }

    public void delete(UUID favouriteUserItemId) {
        this.favouriteUserItemService.deleteById(JwtTokenHolder.getUserIdOrThrow(), favouriteUserItemId);
    }

    public OutputFavouriteUserItemDto patch(UUID favouriteUserItemId, InputPatchFavouriteUserItemDto dto) {
        return this.favouriteUserItemService.patchById(JwtTokenHolder.getUserIdOrThrow(), favouriteUserItemId, dto);
    }

    @NonNull
    public Page<OutputFavouriteUserItemDto> findByContext(ItemContext context, String subContext, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort.Direction)direction, (String[])new String[]{sort});
        return this.favouriteUserItemService.findByContext(JwtTokenHolder.getUserIdOrThrow(), context, subContext, (Pageable)pageable);
    }

    public List<OutputFavouriteUserItemDto> findByContextAndItemIds(ItemContext context, String subContext, String itemIds, String itemIdSeparator) {
        LinkedHashSet<String> itemIdSet = new LinkedHashSet<String>(Arrays.asList(itemIds.split(itemIdSeparator)));
        return this.favouriteUserItemService.findByContextAndItemIds(JwtTokenHolder.getUserIdOrThrow(), context, subContext, itemIdSet);
    }

    public Page<OutputFavouriteUserItemSubscriberDto> findSubscribers(ItemContext context, String subContext, String itemId, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort.Direction)direction, (String[])new String[]{sort});
        return this.favouriteUserItemService.findSubscribers(context, subContext, itemId, (Pageable)pageable);
    }

    public List<OutputFavouriteUserItemDto> deleteByContextAndItemId(ItemContext context, String subContext, String itemId) {
        return this.favouriteUserItemService.deleteByContextAndItemId(context, subContext, itemId);
    }

    @Generated
    public FavouriteUserItemController(FavouriteUserItemService favouriteUserItemService) {
        this.favouriteUserItemService = favouriteUserItemService;
    }
}

