create schema if not exists "wp2_favourite_user";

set schema 'wp2_favourite_user';

-- drop table if exists "favourite_user_item";
create table if not exists "favourite_user_item"
(
    id            uuid primary key,
    user_id       uuid                        not null,
    context       varchar(100)                not null,
    sub_context   varchar(100),
    item_id       varchar(100)                not null,
    creation_time timestamp without time zone not null DEFAULT current_timestamp,
    update_time   timestamp without time zone,
    version       bigint                      not null default 0,
    followed      boolean                     not null default false
);

-- drop index if exists favourite_user_item_user_id_context_idx;
create index if not exists favourite_user_item_user_id_context_idx ON favourite_user_item (user_id, upper(context));


-- drop table if exists "archived_favourite_user_item";
create table if not exists "archived_favourite_user_item"
(
    id            uuid primary key,
    user_id       uuid                        not null,
    context       varchar(100)                not null,
    sub_context   varchar(100),
    item_id       varchar(100)                not null,
    creation_time timestamp without time zone not null DEFAULT current_timestamp,
    update_time   timestamp without time zone,
    archival_time timestamp without time zone not null DEFAULT current_timestamp,
    version       bigint                      not null default 0,
    followed      boolean                     not null default false
);