package com.finconsgroup.itserr.marketplace.favourite.user.dm.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.finconsgroup.itserr.marketplace.core.web.dto.PutIdParameterBody;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.UUID;

/**
 * Favourite User Item patch request dto.
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class InputPatchFavouriteUserItemDto implements PutIdParameterBody {

    @Schema(
        description = "Favourite User Item Id",
        example = "f81d4fae-7dec-11d0-a765-00a0c91e6bf6")
    @NotNull
    private UUID id;

    @Schema(
        description = "Followed",
        example = "true")
    private Boolean followed;

    @JsonIgnore
    @Hidden
    @Override
    public String getPutId() {
        return id != null ? id.toString() : null;
    }
}
