package com.finconsgroup.itserr.marketplace.favourite.user.dm.converter;

import com.finconsgroup.itserr.marketplace.favourite.user.dm.enums.ItemContext;
import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;

/**
 * Attribute Converter for handling conversion between {@link ItemContext} and {@link String}
 */
@Converter
public class ItemContextAttributeConverter implements AttributeConverter<ItemContext, String> {

    @Override
    public String convertToDatabaseColumn(ItemContext attribute) {
        if (attribute == null) {
            return null;
        }
        return attribute.getId();
    }

    @Override
    public ItemContext convertToEntityAttribute(String dbData) {
        if (dbData == null) {
            return null;
        }

        return ItemContext.ofId(dbData);
    }
}
