package com.finconsgroup.itserr.marketplace.favourite.user.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import lombok.Builder;
import lombok.Data;

import java.util.List;

/**
 * It represents the payload to perform a favourite detail get operation.
 */
@Builder
@Schema(
    title = "Perform favourite detail get input DTO",
    description = "Represents the payload to perform favourite detail get operation."
)
@Data
public class InputFindFavouriteDetailDto {
    @Schema(
        description = "IDs",
        example = "[\"123e4567-e89b-12d3-a456-426614174000\",\"123e4567-e89b-12d3-a456-426614174000\"]")
    @NotEmpty
    private List<String> ids;
}
