package com.finconsgroup.itserr.marketplace.favourite.user.bs.dto;


import com.fasterxml.jackson.annotation.JsonInclude;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.enums.ItemContext;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import static com.finconsgroup.itserr.marketplace.favourite.user.bs.util.DomainConstants.ITEM_ID_LENGTH;
import static com.finconsgroup.itserr.marketplace.favourite.user.bs.util.DomainConstants.SUB_CONTEXT_LENGTH;

/**
 * Favourite User Item create request dto.
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class InputCreateFavouriteUserItemDto {

    @Schema(
        description = "Item context",
        example = "catalog")
    @NotNull(message = "favourite_user_bs_context_null_or_invalid")
    private ItemContext context;

    @Schema(
        description = "Item subcontext",
        example = "dataset")
    @Size(max = SUB_CONTEXT_LENGTH)
    private String subContext;

    @Schema(
        description = "Item Id",
        example = "f81d4fae-7dec-11d0-a765-00a0c91e6bf6")
    @NotBlank
    @Size(max = ITEM_ID_LENGTH)
    private String itemId;

    @Schema(
        description = "Followed",
        example = "true")
    private boolean followed;
}
