package com.finconsgroup.itserr.marketplace.favourite.user.bs.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.lang.NonNull;

/**
 * Interface that should be implemented by all detail dto types
 */
public interface FavouriteUserItemDetail {
    /**
     * Returns the item id that can be used for mapping to the favourite user item.
     *
     * @return item id
     */
    @Schema(hidden = true)
    @JsonIgnore
    @Hidden
    @NonNull
    String getItemId();
}
