/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.people;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.people.OutputExpertiseDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.people.OutputUserProfileDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@Schema(name="OutputUserProfile", description="DTO representing a userprofile in responses")
public class OutputUserProfileDto {
    @Schema(description="Unique identifier of the user profile", example="550e8400-e29b-41d4-a716-446655440000")
    private UUID id;
    @Schema(description="First name of the user", example="John")
    private String firstName;
    @Schema(description="Last name of the user", example="Doe")
    private String lastName;
    @Schema(description="preferred Username of the user", example="john.doe.213213")
    private String preferredUsername;
    @Schema(description="Link of the image of user", example="https://imageLink")
    private String imageUrl;
    @Schema(description="ORCID identifier of the user", example="0000-0002-1825-0097")
    private String orcid;
    @Schema(description="Short biography of the user", example="Ricercatore Legge 210/10 a tempo indeterminato")
    private String shortBio;
    @Schema(description="Organization affiliation", example="Stanford University")
    private String organizationAffiliation;
    @Schema(description="Scientific Disciplinary Sectors", example="[\"INF/01\", \"ING-INF/05\"]")
    private List<String> ssd;
    @Schema(description="Areas of Expertise")
    private List<OutputExpertiseDto> expertises;
    @Schema(description="The creation time of the table record", example="2025-04-06T10:15:30+01:00")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime creationTime;
    @Schema(description="The last update time of the table record", example="2025-04-06T10:15:30+01:00")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime updateTime;
    @Schema(description="User preferred language", example="EN")
    @NotBlank
    private String language;
    @JsonIgnore
    private String name;

    @JsonIgnore
    public String getName() {
        if (StringUtils.isBlank((CharSequence)this.name)) {
            this.name = StringUtils.isBlank((CharSequence)this.lastName) ? this.firstName : (StringUtils.isBlank((CharSequence)this.firstName) ? this.lastName : this.firstName + " " + this.lastName);
        }
        return this.name;
    }

    @Generated
    public static OutputUserProfileDtoBuilder builder() {
        return new OutputUserProfileDtoBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public String getFirstName() {
        return this.firstName;
    }

    @Generated
    public String getLastName() {
        return this.lastName;
    }

    @Generated
    public String getPreferredUsername() {
        return this.preferredUsername;
    }

    @Generated
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Generated
    public String getOrcid() {
        return this.orcid;
    }

    @Generated
    public String getShortBio() {
        return this.shortBio;
    }

    @Generated
    public String getOrganizationAffiliation() {
        return this.organizationAffiliation;
    }

    @Generated
    public List<String> getSsd() {
        return this.ssd;
    }

    @Generated
    public List<OutputExpertiseDto> getExpertises() {
        return this.expertises;
    }

    @Generated
    public ZonedDateTime getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public ZonedDateTime getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Generated
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Generated
    public void setPreferredUsername(String preferredUsername) {
        this.preferredUsername = preferredUsername;
    }

    @Generated
    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    @Generated
    public void setOrcid(String orcid) {
        this.orcid = orcid;
    }

    @Generated
    public void setShortBio(String shortBio) {
        this.shortBio = shortBio;
    }

    @Generated
    public void setOrganizationAffiliation(String organizationAffiliation) {
        this.organizationAffiliation = organizationAffiliation;
    }

    @Generated
    public void setSsd(List<String> ssd) {
        this.ssd = ssd;
    }

    @Generated
    public void setExpertises(List<OutputExpertiseDto> expertises) {
        this.expertises = expertises;
    }

    @Generated
    public void setCreationTime(ZonedDateTime creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(ZonedDateTime updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setLanguage(String language) {
        this.language = language;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutputUserProfileDto)) {
            return false;
        }
        OutputUserProfileDto other = (OutputUserProfileDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        String this$preferredUsername = this.getPreferredUsername();
        String other$preferredUsername = other.getPreferredUsername();
        if (this$preferredUsername == null ? other$preferredUsername != null : !this$preferredUsername.equals(other$preferredUsername)) {
            return false;
        }
        String this$imageUrl = this.getImageUrl();
        String other$imageUrl = other.getImageUrl();
        if (this$imageUrl == null ? other$imageUrl != null : !this$imageUrl.equals(other$imageUrl)) {
            return false;
        }
        String this$orcid = this.getOrcid();
        String other$orcid = other.getOrcid();
        if (this$orcid == null ? other$orcid != null : !this$orcid.equals(other$orcid)) {
            return false;
        }
        String this$shortBio = this.getShortBio();
        String other$shortBio = other.getShortBio();
        if (this$shortBio == null ? other$shortBio != null : !this$shortBio.equals(other$shortBio)) {
            return false;
        }
        String this$organizationAffiliation = this.getOrganizationAffiliation();
        String other$organizationAffiliation = other.getOrganizationAffiliation();
        if (this$organizationAffiliation == null ? other$organizationAffiliation != null : !this$organizationAffiliation.equals(other$organizationAffiliation)) {
            return false;
        }
        List this$ssd = this.getSsd();
        List other$ssd = other.getSsd();
        if (this$ssd == null ? other$ssd != null : !((Object)this$ssd).equals(other$ssd)) {
            return false;
        }
        List this$expertises = this.getExpertises();
        List other$expertises = other.getExpertises();
        if (this$expertises == null ? other$expertises != null : !((Object)this$expertises).equals(other$expertises)) {
            return false;
        }
        ZonedDateTime this$creationTime = this.getCreationTime();
        ZonedDateTime other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        ZonedDateTime this$updateTime = this.getUpdateTime();
        ZonedDateTime other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OutputUserProfileDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        String $preferredUsername = this.getPreferredUsername();
        result = result * 59 + ($preferredUsername == null ? 43 : $preferredUsername.hashCode());
        String $imageUrl = this.getImageUrl();
        result = result * 59 + ($imageUrl == null ? 43 : $imageUrl.hashCode());
        String $orcid = this.getOrcid();
        result = result * 59 + ($orcid == null ? 43 : $orcid.hashCode());
        String $shortBio = this.getShortBio();
        result = result * 59 + ($shortBio == null ? 43 : $shortBio.hashCode());
        String $organizationAffiliation = this.getOrganizationAffiliation();
        result = result * 59 + ($organizationAffiliation == null ? 43 : $organizationAffiliation.hashCode());
        List $ssd = this.getSsd();
        result = result * 59 + ($ssd == null ? 43 : ((Object)$ssd).hashCode());
        List $expertises = this.getExpertises();
        result = result * 59 + ($expertises == null ? 43 : ((Object)$expertises).hashCode());
        ZonedDateTime $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        ZonedDateTime $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OutputUserProfileDto(id=" + String.valueOf(this.getId()) + ", firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", preferredUsername=" + this.getPreferredUsername() + ", imageUrl=" + this.getImageUrl() + ", orcid=" + this.getOrcid() + ", shortBio=" + this.getShortBio() + ", organizationAffiliation=" + this.getOrganizationAffiliation() + ", ssd=" + String.valueOf(this.getSsd()) + ", expertises=" + String.valueOf(this.getExpertises()) + ", creationTime=" + String.valueOf(this.getCreationTime()) + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ", language=" + this.getLanguage() + ", name=" + this.getName() + ")";
    }

    @Generated
    public OutputUserProfileDto() {
    }

    @Generated
    public OutputUserProfileDto(UUID id, String firstName, String lastName, String preferredUsername, String imageUrl, String orcid, String shortBio, String organizationAffiliation, List<String> ssd, List<OutputExpertiseDto> expertises, ZonedDateTime creationTime, ZonedDateTime updateTime, String language, String name) {
        this.id = id;
        this.firstName = firstName;
        this.lastName = lastName;
        this.preferredUsername = preferredUsername;
        this.imageUrl = imageUrl;
        this.orcid = orcid;
        this.shortBio = shortBio;
        this.organizationAffiliation = organizationAffiliation;
        this.ssd = ssd;
        this.expertises = expertises;
        this.creationTime = creationTime;
        this.updateTime = updateTime;
        this.language = language;
        this.name = name;
    }
}

