package com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.search;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.UUID;

/**
 * Output DTO representing a userprofile in catalog item.
 */
@Schema(name = "OutputCatalogUserProfileDto", description = "DTO representing a userprofile in catalog item responses")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputCatalogUserProfileDto {

    @Schema(description = "Unique identifier of the user profile", example = "550e8400-e29b-41d4-a716-446655440000")
    private UUID id;

    @Schema(description = "First name of the user", example = "John")
    private String firstName;

    @Schema(description = "Last name of the user", example = "Doe")
    private String lastName;

    @Schema(description = "Email", example = "john.doe@example.com")
    private String email;

    @Schema(description = "ORCID identifier of the user", example = "0000-0002-1825-0097")
    private String orcid;
}
