package com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.catalog;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.UUID;

/**
 * Full details DTO for a catalog item
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputItemDto {

    /** Unique identifier of the catalog item */
    private UUID id;

    /** Display title of the catalog item */
    private String title;

    /** Detailed description of the catalog item */
    private String description;

    /** User profile associated with the maintainer */
    private OutputCatalogUserProfileDto maintainer;

}
