package com.finconsgroup.itserr.marketplace.favourite.user.bs.service.impl;

import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.FavouriteUserItemDetail;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.enums.ItemContext;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.service.FavouriteUserItemDetailProvider;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.service.FavouriteUserItemDetailProviderRegistry;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@Service
public class DefaultFavouriteUserItemDetailProviderRegistry implements FavouriteUserItemDetailProviderRegistry {
    private final Map<ItemContext, FavouriteUserItemDetailProvider<?>> favouriteUserItemDetailProvidersByItemContext =
        new ConcurrentHashMap<>();

    @Override
    public <T extends FavouriteUserItemDetail> void register(@NonNull ItemContext itemContext,
                                                             @NonNull FavouriteUserItemDetailProvider<T> favouriteUserItemDetailProvider) {
        Objects.requireNonNull(itemContext, "itemContext cannot be null");
        Objects.requireNonNull(favouriteUserItemDetailProvider, "favouriteUserItemDetailProvider cannot be null");

        favouriteUserItemDetailProvidersByItemContext.put(itemContext, favouriteUserItemDetailProvider);
    }

    @NonNull
    @Override
    @SuppressWarnings("unchecked")
    public <T extends FavouriteUserItemDetail> Optional<FavouriteUserItemDetailProvider<T>> getProvider(@NonNull ItemContext itemContext) {
        Objects.requireNonNull(itemContext, "itemContext cannot be null");

        return Optional.ofNullable((FavouriteUserItemDetailProvider<T>) favouriteUserItemDetailProvidersByItemContext.get(itemContext));
    }
}
