package com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.search;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * It represents the response for tags field for a Catalog search document.
 */
@Builder
@Schema(
    title = "Catalog search document tag response DTO",
    description = "Represents the response for tags field for Catalog search document"
)
@Data
@AllArgsConstructor
@NoArgsConstructor
public class OutputCatalogMinimalTagDto {

    @Schema(
        description = "ID",
        example = "dc7e376a-059b-49be-90a0-e7fbdbcdc0ba")
    private String id;

    @Schema(
        description = "Display Name",
        example = "ITSERR")
    private String displayName;

}
