package com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.catalog;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.UUID;

/**
 * Output Dto of a User Profile related to catalog item.
 */
@Schema(
        name = "OutputCatalogUserProfileDto",
        description = "Output Dto of a user profile related to catalog item"
)
@Data
@Builder
@AllArgsConstructor
public class OutputCatalogUserProfileDto {

    @Schema(
            description = "User profile identifier (alternative to explicit details)",
            example = "3fa85f64-5717-4562-b3fc-2c963f66afa6"
    )
    private UUID id;

    @Schema(description = "First name", example = "Mario")
    private String firstName;

    @Schema(description = "Last name", example = "Rossi")
    private String lastName;

    @Schema(description = "Email address", example = "mario.rossi@example.com")
    private String email;

}
