package com.finconsgroup.itserr.marketplace.favourite.user.bs.converter;

import com.finconsgroup.itserr.marketplace.favourite.user.bs.enums.ItemContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;

/**
 * Converter class for converting from {@link String} to {@link ItemContext}.
 * Mostly used by the conversion for request parameters.
 */
public class StringToItemContextConverter implements Converter<String, ItemContext> {
    @Override
    public ItemContext convert(@NonNull String source) {
        if (StringUtils.isBlank(source)) {
            return null;
        }

        return ItemContext.ofId(source.toLowerCase());
    }
}
