package com.finconsgroup.itserr.marketplace.favourite.user.bs.config;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Messaging-related configuration properties.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MessagingProperties {

    /**
     * Configuration for catalog-bs messaging.
     */
    @NotNull
    @Valid
    private MessagingCatalogBsProperties catalogBs;

    /**
     * Configuration for institutional-page-bs messaging.
     */
    @NotNull
    @Valid
    private MessagingInstitutionalPageBsProperties institutionalPageBs;

    /**
     * Configuration for event-bs messaging.
     */
    @NotNull
    @Valid
    private MessagingEventBsProperties eventBs;

    /**
     * Configuration for news-bs messaging.
     */
    @NotNull
    @Valid
    private MessagingNewsBsProperties newsBs;

}
