create schema if not exists "wp2_favourite_search";

set schema 'wp2_favourite_search';

create table if not exists "favourite_search"(
    id uuid primary key,
    name varchar(255) not null,
    user_id uuid not null,
    context varchar(255) not null,
    search_text varchar(255) not null,
    search_filters varchar(8192),
    creation_time timestamptz(6) not null,
    update_time timestamptz(6) not null,
    version bigint not null default 0
    );

create table if not exists "archived_favourite_search"(
    id uuid primary key,
    name varchar(255) not null,
    user_id uuid not null,
    context varchar(255) not null,
    search_text varchar(255) not null,
    search_filters varchar(8192),
    creation_time timestamptz(6) not null,
    update_time timestamptz(6) not null,
    archival_time timestamptz(6)  not null,
    version bigint not null default 0
    );

-- Index to efficiently fetch the latest favourite searches for a user
create index if not exists idx_userid_updatetime
    on favourite_search(user_id, update_time desc);
