/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.favouritesearch.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.converter.SearchContextAttributeConverter;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.entity.ArchivedFavouriteSearchEntity;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.enums.SearchContext;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="archived_favourite_search")
public class ArchivedFavouriteSearchEntity
extends AbstractUUIDEntity {
    @Column(name="name", nullable=false, updatable=false)
    private String name;
    @Column(name="user_id", nullable=false, updatable=false)
    private UUID userId;
    @Column(name="context", nullable=false, updatable=false)
    @Convert(converter=SearchContextAttributeConverter.class)
    private SearchContext context;
    @Column(name="search_text", nullable=false, updatable=false)
    private String searchText;
    @Column(name="search_filters", updatable=false)
    private String searchFilters;
    @Column(name="creation_time", nullable=false, updatable=false)
    private ZonedDateTime creationTime;
    @Column(name="update_time", nullable=false, updatable=false)
    private ZonedDateTime updateTime;
    @Column(name="archival_time", nullable=false, updatable=false)
    private ZonedDateTime archivalTime;
    @Version
    private long version;

    @PrePersist
    public void onCreate() {
        this.archivalTime = ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.MICROS);
    }

    @Generated
    protected ArchivedFavouriteSearchEntity(ArchivedFavouriteSearchEntityBuilder<?, ?> b) {
        super(b);
        this.name = b.name;
        this.userId = b.userId;
        this.context = b.context;
        this.searchText = b.searchText;
        this.searchFilters = b.searchFilters;
        this.creationTime = b.creationTime;
        this.updateTime = b.updateTime;
        this.archivalTime = b.archivalTime;
        this.version = b.version;
    }

    @Generated
    public static ArchivedFavouriteSearchEntityBuilder<?, ?> builder() {
        return new ArchivedFavouriteSearchEntityBuilderImpl();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public UUID getUserId() {
        return this.userId;
    }

    @Generated
    public SearchContext getContext() {
        return this.context;
    }

    @Generated
    public String getSearchText() {
        return this.searchText;
    }

    @Generated
    public String getSearchFilters() {
        return this.searchFilters;
    }

    @Generated
    public ZonedDateTime getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public ZonedDateTime getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public ZonedDateTime getArchivalTime() {
        return this.archivalTime;
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    @Generated
    public void setContext(SearchContext context) {
        this.context = context;
    }

    @Generated
    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    @Generated
    public void setSearchFilters(String searchFilters) {
        this.searchFilters = searchFilters;
    }

    @Generated
    public void setCreationTime(ZonedDateTime creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(ZonedDateTime updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setArchivalTime(ZonedDateTime archivalTime) {
        this.archivalTime = archivalTime;
    }

    @Generated
    public void setVersion(long version) {
        this.version = version;
    }

    @Generated
    public String toString() {
        return "ArchivedFavouriteSearchEntity(name=" + this.getName() + ", userId=" + String.valueOf(this.getUserId()) + ", context=" + String.valueOf(this.getContext()) + ", searchText=" + this.getSearchText() + ", searchFilters=" + this.getSearchFilters() + ", creationTime=" + String.valueOf(this.getCreationTime()) + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ", archivalTime=" + String.valueOf(this.getArchivalTime()) + ", version=" + this.getVersion() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArchivedFavouriteSearchEntity)) {
            return false;
        }
        ArchivedFavouriteSearchEntity other = (ArchivedFavouriteSearchEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        UUID this$userId = this.getUserId();
        UUID other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        SearchContext this$context = this.getContext();
        SearchContext other$context = other.getContext();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        String this$searchText = this.getSearchText();
        String other$searchText = other.getSearchText();
        if (this$searchText == null ? other$searchText != null : !this$searchText.equals(other$searchText)) {
            return false;
        }
        String this$searchFilters = this.getSearchFilters();
        String other$searchFilters = other.getSearchFilters();
        if (this$searchFilters == null ? other$searchFilters != null : !this$searchFilters.equals(other$searchFilters)) {
            return false;
        }
        ZonedDateTime this$creationTime = this.getCreationTime();
        ZonedDateTime other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        ZonedDateTime this$updateTime = this.getUpdateTime();
        ZonedDateTime other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        ZonedDateTime this$archivalTime = this.getArchivalTime();
        ZonedDateTime other$archivalTime = other.getArchivalTime();
        return !(this$archivalTime == null ? other$archivalTime != null : !((Object)this$archivalTime).equals(other$archivalTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArchivedFavouriteSearchEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        UUID $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        SearchContext $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        String $searchText = this.getSearchText();
        result = result * 59 + ($searchText == null ? 43 : $searchText.hashCode());
        String $searchFilters = this.getSearchFilters();
        result = result * 59 + ($searchFilters == null ? 43 : $searchFilters.hashCode());
        ZonedDateTime $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        ZonedDateTime $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        ZonedDateTime $archivalTime = this.getArchivalTime();
        result = result * 59 + ($archivalTime == null ? 43 : ((Object)$archivalTime).hashCode());
        return result;
    }

    @Generated
    public ArchivedFavouriteSearchEntity() {
    }
}

