package com.finconsgroup.itserr.marketplace.favouritesearch.dm.controller;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.api.FavouriteSearchApi;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.dto.InputCreateFavouriteSearchDto;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.dto.OutputFavouriteSearchDto;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.entity.FavouriteSearchEntity;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.enums.SearchContext;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.service.FavouriteSearchService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort.Direction;
import org.springframework.web.bind.annotation.RestController;

import java.util.UUID;

/**
 * REST controller class for handling {@link FavouriteSearchEntity} related API requests.
 *
 * <p>Implements the {@link FavouriteSearchApi} interface.</p>
 */
@Slf4j
@RequiredArgsConstructor
@RestController
public class FavouriteSearchController implements FavouriteSearchApi {

    private final FavouriteSearchService favouriteSearchService;

    @Override
    public OutputFavouriteSearchDto create(
            final InputCreateFavouriteSearchDto inputCreateFavouriteSearchDto
    ) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.favouriteSearchService.create(userId, inputCreateFavouriteSearchDto);
    }

    @Override
    public Page<OutputFavouriteSearchDto> findAll(
            final SearchContext context,
            final String searchText,
            final int pageNumber,
            final int pageSize,
            final String sort,
            final Direction direction
    ) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        Pageable pageable = PageRequest.of(pageNumber, pageSize, direction, sort);
        return this.favouriteSearchService.findAll(userId, context, searchText, pageable);
    }

    @Override
    public OutputFavouriteSearchDto findById(final UUID favouriteSearchId) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.favouriteSearchService.findById(userId, favouriteSearchId);
    }

    @Override
    public void deleteById(final UUID favouriteSearchId) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        this.favouriteSearchService.deleteById(userId, favouriteSearchId);
    }

}
