/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.favouritesearch.dm.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.dto.InputCreateFavouriteSearchDto;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.dto.OutputFavouriteSearchDto;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.dto.SearchFilterFavouriteSearchDto;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.entity.FavouriteSearchEntity;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.mapper.MapperConfiguration;
import java.util.List;
import java.util.UUID;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.Named;

@Mapper(config=MapperConfiguration.class)
public interface FavouriteSearchMapper {
    public static final String SEARCH_FILTERS_SERIALIZE = "serializeSearchFilters";
    public static final String SEARCH_FILTERS_DESERIALIZE = "deserializeSearchFilters";

    @Mappings(value={@Mapping(target="id", ignore=true), @Mapping(target="creationTime", ignore=true), @Mapping(target="updateTime", ignore=true), @Mapping(target="version", ignore=true), @Mapping(target="searchFilters", source="model.searchFilters", qualifiedByName={"serializeSearchFilters"})})
    public FavouriteSearchEntity toEntity(InputCreateFavouriteSearchDto var1, UUID var2);

    @Mapping(target="searchFilters", source="searchFilters", qualifiedByName={"deserializeSearchFilters"})
    public OutputFavouriteSearchDto toDto(FavouriteSearchEntity var1);

    @Named(value="serializeSearchFilters")
    public static String serializeSearchFilters(List<SearchFilterFavouriteSearchDto> searchFilters) {
        if (searchFilters == null) {
            return null;
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.writeValueAsString(searchFilters);
        }
        catch (JsonProcessingException e) {
            throw new WP2BusinessException("Failed to serialize searchFilters", (Throwable)e);
        }
    }

    @Named(value="deserializeSearchFilters")
    public static List<SearchFilterFavouriteSearchDto> deserializeSearchFilters(String searchFilters) {
        if (searchFilters == null) {
            return null;
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return (List)objectMapper.readValue(searchFilters, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (JsonProcessingException e) {
            throw new WP2BusinessException("Failed to deserialize searchFilters", (Throwable)e);
        }
    }
}

