/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.favouritesearch.dm.api;

import com.finconsgroup.itserr.marketplace.favouritesearch.dm.dto.InputCreateFavouriteSearchDto;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.dto.OutputFavouriteSearchDto;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.enums.SearchContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Tag(name="FavouriteSearch", description="The FavouriteSearch API: it provides endpoints for retrieving, creating, and deleting FavouriteSearch.")
@SecurityRequirement(name="BearerAuth")
public interface FavouriteSearchApi {
    @Operation(summary="create a favouriteSearch for the authenticated user", responses={@ApiResponse(responseCode="201", description="Created")})
    @PostMapping(value={"/favourite-searches"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public OutputFavouriteSearchDto create(@Valid @RequestBody InputCreateFavouriteSearchDto var1);

    @Operation(summary="find all favouriteSearches for the authenticated user", responses={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(value={"/favourite-searches"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Page<OutputFavouriteSearchDto> findAll(@RequestParam(name="context", required=false) SearchContext var1, @RequestParam(name="searchText", defaultValue="", required=false) String var2, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var3, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var4, @RequestParam(name="sort", defaultValue="creationTime", required=false) String var5, @RequestParam(name="direction", defaultValue="DESC", required=false) Sort.Direction var6);

    @Operation(summary="find favouriteSearch by id for the authenticated user", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found")})
    @GetMapping(value={"/favourite-searches/{favouriteSearchId}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputFavouriteSearchDto findById(@PathVariable(value="favouriteSearchId") UUID var1);

    @Operation(summary="delete favouriteSearch by id for the authenticated user", responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="404", description="Not Found")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @DeleteMapping(value={"/favourite-searches/{favouriteSearchId}"}, produces={"application/json"})
    public void deleteById(@PathVariable(value="favouriteSearchId") UUID var1);
}

