package com.finconsgroup.itserr.marketplace.favouritesearch.bs.service.impl;

import com.finconsgroup.itserr.marketplace.favouritesearch.bs.client.FavouriteSearchDmClient;
import com.finconsgroup.itserr.marketplace.favouritesearch.bs.dto.InputCreateFavouriteSearchDto;
import com.finconsgroup.itserr.marketplace.favouritesearch.bs.dto.OutputFavouriteSearchDto;
import com.finconsgroup.itserr.marketplace.favouritesearch.bs.service.FavouriteSearchService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

import java.util.UUID;

/**
 * Default implementation of {@link FavouriteSearchService}
 * to perform operations related to favouriteSearch resources
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class DefaultFavouriteSearchService implements FavouriteSearchService {

    @Autowired
    FavouriteSearchDmClient favouriteSearchDmClient;


    @NonNull
    @Override
    public OutputFavouriteSearchDto create(@NonNull UUID userId, @NonNull InputCreateFavouriteSearchDto inputCreateFavouriteSearchDto) {
        return favouriteSearchDmClient.create(inputCreateFavouriteSearchDto);
    }

    /**
     * @param favouriteSearchId the id of the favouriteSearch to delete
     */
    @Override
    public void deleteById(UUID favouriteSearchId) {
        favouriteSearchDmClient.deleteById(favouriteSearchId);
    }
}