package com.finconsgroup.itserr.marketplace.favouritesearch.bs.service;

import com.finconsgroup.itserr.marketplace.favouritesearch.bs.dto.InputCreateFavouriteSearchDto;
import com.finconsgroup.itserr.marketplace.favouritesearch.bs.dto.OutputFavouriteSearchDto;
import org.springframework.lang.NonNull;


import java.util.UUID;

/**
 * Service for handling business logic related to FavouriteSearches.
 * This interface provides methods to create FavouriteSearches
 *
 * <p>Example usage:
 * <pre>
 * OutputFavouriteSearchDto favouriteSearch =
 *     favouriteSearchService.create(userId, inputCreateFavouriteSearchDto);
 * </pre>
 * </p>
 */
public interface FavouriteSearchService {

    /**
     * Creates a new favouriteSearch for the authenticated user using the provided input data.
     *
     * @param userId                           the unique identifier of the user
     * @param inputCreateFavouriteSearchDto the input DTO containing favouriteSearch details
     * @return an OutputFavouriteSearchDto representing the created favouriteSearch
     */
    @NonNull
    OutputFavouriteSearchDto create(
            @NonNull UUID userId,
            @NonNull InputCreateFavouriteSearchDto inputCreateFavouriteSearchDto
    );

    /**
     * Deletes a favouriteSearch by id for the authenticated user.
     *
     * @param favouriteSearchId the id of the favouriteSearch to delete
     */
    @NonNull
    void deleteById(UUID favouriteSearchId);
}
