/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.favouritesearch.bs.controller;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.favouritesearch.bs.api.DiagnosticsApi;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
public class DiagnosticsController
implements DiagnosticsApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiagnosticsController.class);
    @Value(value="${log.log4j2-rolling-file-name}")
    private String log4j2RollingFileName;

    public ResponseEntity<Resource> downloadLogs() {
        log.debug("call to DiagnosticsController - downloadLogs");
        Path filePath = Paths.get(this.getLogFilePathFromLog4j2(), new String[0]);
        log.debug("Trying to retrieve log file from: {}", (Object)filePath);
        File logFile = filePath.toFile();
        if (!logFile.exists() || !logFile.isFile()) {
            throw new WP2ResourceNotFoundException("Log file not found: %s".formatted(logFile.getAbsolutePath()));
        }
        FileSystemResource resource = new FileSystemResource(logFile);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{DiagnosticsController.getContentDispositionHeaderValue((String)logFile.getName())})).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)resource);
    }

    public String getLogFilePathFromLog4j2() {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        RollingFileAppender appender = (RollingFileAppender)context.getConfiguration().getAppender(this.log4j2RollingFileName);
        return appender.getFileName();
    }

    private static String getContentDispositionHeaderValue(String fileName) {
        return "attachment; filename=\"%s\"".formatted(fileName);
    }

    @Generated
    public DiagnosticsController() {
    }
}

