package com.finconsgroup.itserr.marketplace.favouritesearch.bs.client;


import com.finconsgroup.itserr.marketplace.favouritesearch.bs.dto.InputCreateFavouriteSearchDto;
import com.finconsgroup.itserr.marketplace.favouritesearch.bs.dto.OutputFavouriteSearchDto;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;

import java.util.UUID;

public interface FavouriteSearchDmClient {


    /**
     * Create a user's search
     *
     * @param inputCreateFavouriteSearchDto an user's favourite search
     * @return an object representing the user's favourite search
     * @throws feign.FeignException.FeignClientException.NotFound if the type does not exist
     * @throws feign.FeignException.FeignClientException.InternalServerError if there is an error inside the dm service
     */
    @PostMapping("/favourite-searches")
    OutputFavouriteSearchDto create(InputCreateFavouriteSearchDto inputCreateFavouriteSearchDto);

    /**
     * Delete (soft) a user's search
     *
     * @param favouriteSearchId a user's favourite search id
     * @throws feign.FeignException.FeignClientException.NotFound if the favourite search does not exist
     * @throws feign.FeignException.FeignClientException.InternalServerError if there is an error inside the dm service
     */
    @DeleteMapping("/favourite-searches/{favouriteSearchId}")
    void deleteById(@PathVariable("favouriteSearchId") UUID favouriteSearchId);
}
